#include <tqmetaobject.h>
#include <private/qucom_p.h>

#include <tqpen.h>
#include <tqpixmap.h>
#include <tqimage.h>
#include <tqvariant.h>
#include <tqdatetime.h>
#include <tqsize.h>

#include <kjs/interpreter.h>
#include <kjs/ustring.h>
#include <kjs/types.h>
#include <kjs/value.h>

#include "global.h"
#include "jsbinding.h"
#include "jsobjectproxy.h"
#include "jsfactory.h"
#include "jsvalueproxy.h"
#include "jsopaqueproxy.h"
#include "jsbuiltinproxy.h"
#include "kjsembedpart.h"

#include "bindings/pen_imp.h"
#include "bindings/image_imp.h"
#include "bindings/pixmap_imp.h"
#include "bindings/painter_imp.h"
#include "bindings/brush_imp.h"
#include "bindings/size_imp.h"
#include "bindings/point_imp.h"
#include "bindings/rect_imp.h"

#include <stdlib.h>

namespace KJSEmbed {

    //
    //
    // Supported
    // =========
    //
    // Bool, Double, CString, String, StringList, Int, UInt, Date, Time, DateTime,
    // Rect, Size, Point, Pixmap, Image, Brush, Pen, Size, Rect, Point, TQValueList<TQVariant>
    //
    // Opqaue
    // ======
    //
    // Invalid, Map, List, Palette, ColorGroup,
    // IconSet, PointArray, Region, Bitmap, Cursor, SizePolicy,
    // ByteArray, BitArray
    //

    KJS::Value convertToValue( KJS::ExecState *exec, const TQVariant &val ) {
        if ( !val.isValid() )
            return KJS::Undefined();

        kdDebug( 80001 ) << "Convert a " << val.typeName() << " to a value" << endl;
        KJS::List items;
        uint type = val.type();

        switch( type )
        {
            case TQVariant::String:
            case TQVariant::CString:
                return KJS::String( val.toString() );
                break;
            case TQVariant::Int:
                return KJS::Number( val.toInt() );
                break;
            case TQVariant::UInt:
                return KJS::Number( val.toUInt() );
                break;
            case TQVariant::Double:
                return KJS::Number( val.toDouble() );
                break;
            case TQVariant::Bool:
                return KJS::Boolean( val.toBool() );
                break;
            case TQVariant::Rect:
            {
                JSValueProxy * prx = new JSValueProxy( );
                prx->setValue( val );
                KJS::Object proxyObj( prx );
                Bindings::Rect::addBindings( exec, proxyObj );
                return proxyObj;
                break;
            }
            case TQVariant::Date:
            case TQVariant::DateTime:
            case TQVariant::Time:
            {
                TQDateTime dt = TQDateTime::currentDateTime();
                if ( type == TQVariant::Date )
                    dt.setDate( val.toDate() );
                else if ( type == TQVariant::Time )
                    dt.setTime( val.toTime() );
                else
                    dt = val.toDateTime();
                items.append( KJS::Number( dt.date().year() ) );
                items.append( KJS::Number( dt.date().month() - 1 ) );
                items.append( KJS::Number( dt.date().day() ) );
                items.append( KJS::Number( dt.time().hour() ) );
                items.append( KJS::Number( dt.time().minute() ) );
                items.append( KJS::Number( dt.time().second() ) );
                items.append( KJS::Number( dt.time().msec() ) );
                return KJS::Object( exec->interpreter() ->builtinDate().construct( exec, items ) );
                break;
            }
            case TQVariant::Point:
            {
                JSValueProxy * prx = new JSValueProxy( );
                prx->setValue( val );
                KJS::Object proxyObj( prx );
                Bindings::Point::addBindings( exec, proxyObj );
                return proxyObj;
                break;
            }
            case TQVariant::StringList:
            {
                TQStringList lst = val.toStringList();
                TQStringList::Iterator idx = lst.begin();
                for ( ; idx != lst.end(); ++idx )
                    items.append( KJS::String( ( *idx ) ) );
                return KJS::Object( exec->interpreter() ->builtinArray().construct( exec, items ) );
                break;
            }
            case TQVariant::List:
//            case TQVariant::StringList:  
// This will cause an extra conversion step for a QStrinList so use the above case.
            {
                TQValueList<TQVariant> lst = val.toList();
                TQValueList<TQVariant>::Iterator idx = lst.begin();
                for ( ; idx != lst.end(); ++idx )
                    items.append( convertToValue( exec, ( *idx ) ) );
                return KJS::Object( exec->interpreter() ->builtinArray().construct( exec, items ) );
                break;
            }
            case TQVariant::Map:
            {
                TQMap<TQString,TQVariant> map = val.toMap();
                TQMap<TQString,TQVariant>::Iterator idx = map.begin();
                KJS::Object array( exec->interpreter() ->builtinArray().construct( exec, 0 ) );
                for ( ; idx != map.end(); ++idx )
                    array.put(exec,  KJS::Identifier(idx.key().latin1()), convertToValue( exec,  idx.data() ) );
                return array;
                break;
            }
            case TQVariant::Pixmap:
            {
                JSValueProxy * prx = new JSValueProxy( );
                prx->setValue( val );
                KJS::Object proxyObj( prx );
                Bindings::Pixmap::addBindings( exec, proxyObj );
                return proxyObj;
                break;
            }
            case TQVariant::Brush:
            {
                JSValueProxy * prx = new JSValueProxy( );
                prx->setValue( val );
                KJS::Object proxyObj( prx );
                Bindings::BrushImp::addBindings( exec, proxyObj );
                return proxyObj;
            }
            case TQVariant::Image:
            {
                JSValueProxy * prx = new JSValueProxy( );
                prx->setValue( val );
                KJS::Object proxyObj( prx );
                Bindings::ImageImp::addBindings( exec, proxyObj );
                return proxyObj;
                break;
            }
            case TQVariant::Pen:
            {
                JSValueProxy * prx = new JSValueProxy( );
                prx->setValue( val );
                KJS::Object proxyObj( prx );
                Bindings::Pen::addBindings( exec, proxyObj );
                return proxyObj;
                break;
            }
            case TQVariant::Size:
            {
                JSValueProxy * prx = new JSValueProxy( );
                prx->setValue( val );
                KJS::Object proxyObj( prx );
                Bindings::Size::addBindings( exec, proxyObj );
                return proxyObj;
                break;
            }
            default:
            {
                if ( val.canCast( TQVariant::String ) )
                    return KJS::String( val.toString() );
                else
                {
                    kdDebug( 80001 ) << "convertToValue() Creating value, type wrapper for " << val.typeName() << endl;

                    JSValueProxy *valproxy = new JSValueProxy();
                    KJS::Object obj = KJS::Object( valproxy );
                    valproxy->addBindings( exec, obj );
                    valproxy->setValue( val );

                    return obj;
                }
            }
        }
    }

    TQVariant convertToVariant( KJS::ExecState *exec, const KJS::Value &v ) {
        TQVariant val;
        KJS::Type type = v.type();
        kdDebug( 80001 ) << "Convert a value of type " << type << " to a variant" << endl;
        switch( type )
        {
            case KJS::StringType:
                val = v.toString( exec ).qstring();
                break;
            case  KJS::NumberType:
                val = v.toNumber( exec );
                break;
            case KJS::BooleanType:
                val = v.toBoolean( exec );
                break;
            case KJS::ObjectType:
            {
                KJS::Object obj = v.toObject( exec );
                kdDebug( 80001 ) << "convertToVariant() got an " << obj.className().qstring() << endl;
                if ( obj.className().qstring() == "Array" ) {
                    if ( checkArray( exec, v ) == List )
                       val = convertArrayToList( exec, v );
                    else
                       val = convertArrayToMap(exec, v);
                } else if ( obj.className().qstring() == "Date" ) {
                    val = convertDateToDateTime( exec, v );
		} else if ( obj.className().qstring() == "Function" ) {
		  /*  val = obj.className().qstring();*/
                } else {
                    //JSObjectProxy *prx = JSProxy::toObjectProxy( obj.imp() );
		    JSValueProxy *vprx = JSProxy::toValueProxy(obj.imp() );
		    //JSOpaqueProxy *oprx = JSProxy::toOpaqueProxy( obj.imp() );
		    JSProxy *prxy = dynamic_cast<JSProxy*>(obj.imp());
		    /*
		    kdDebug(80001) << "Type " << obj.imp()->dispatchType() << endl;
    
		    kdDebug(80001) << "Object proxy: " << prx << " Value Proxy: " << vprx << " Opaque Proxy " << oprx << " Proxy " << prxy << endl;
		    kdDebug(80001) << "Object prototype valid " << obj.prototype().isValid() << endl;
		    kdDebug(80001) << "Prototype name: " << obj.prototype().toString(exec).ascii() << endl;
		    kdDebug(80001) << "Proxy imp " << dynamic_cast<JSProxyImp*>(obj.imp()) << endl;
		    kdDebug(80001) << "Builtin " << dynamic_cast<JSBuiltinProxy*>(obj.imp()) << endl;
		    */
                    /*if ( prx ) {
                    
		          TQObject * o = prx->object();
                        TQCString cs( o ? o->className() : "" );
                        if ( obj.implementsConstruct() )
                            val = TQString( "new %1();" ).arg( obj.className().qstring() );
                        else if ( obj.implementsCall() )
                            val = TQString( "%1(...);" ).arg( obj.className().qstring() );
                        kdDebug( 80001 ) << "convertToVariant() got a JSObjectProxy" << endl;         
                    } else */if ( vprx ) {
                        kdDebug( 80001 ) << "convertToVariant() got a variant JSValueProxy" << endl;
                        val = vprx->toVariant();
                    } else if ( prxy ) {
                    /*    kdDebug( 80001 ) << "convertToVariant() got a JSProxy" << endl;
                        val = prxy->typeName();
		      */
		    } else {  // Last resort map the object to a TQMap<TQString,TQVariant>
		      kdDebug( 80001 ) << "convertToVariant() map to struct." << endl;
		      val = convertArrayToMap(exec, v);
                    }
                }
                break;
            }
            default:
            {
                TQString msg = i18n( "Unsupported KJS::Value, type %1" ).arg( ( int ) v.type() );
                throwError(exec, msg);
                val = msg;
                break;
            }
        }
        kdDebug(80001) << "Returning a " << val.typeName() << endl;
        return val;
    }

    TQStringList dumpCompletion( KJS::ExecState *exec, KJS::Object &obj ) {
        TQStringList returnList;
        if ( !obj.isValid() ) {
            return returnList;
        }

        KJS::ReferenceList l = obj.propList( exec );
        KJS::ReferenceListIterator propIt = l.begin();
        while ( propIt != l.end() ) {

            KJS::Identifier name = propIt->getPropertyName( exec );
            if ( obj.hasProperty( exec, name ) ) {
                KJS::Value v = obj.get( exec, name );
                KJS::Object vobj = v.toObject( exec );
                TQString nm( name.ustring().qstring() );
                TQString vl;

                if ( vobj.implementsConstruct() ) {
                    if ( vobj.prototype().toString( exec ).qstring() == "[function]" )
                        returnList << TQString( "%1(...)" ).arg( nm );
                } else if ( vobj.implementsCall() ) {
                    returnList << TQString( "%1(...)" ).arg( nm );
                } else {
                    TQVariant val = convertToVariant( exec, v );
                    vl = val.toString();
                    returnList << nm;
                }
            }

            propIt++;
        }

        JSObjectProxy *proxy = JSProxy::toObjectProxy( obj.imp() );
        TQObject *qo = proxy ? proxy->object() : 0;
        TQMetaObject *mo = qo ? qo->metaObject() : 0;

        // QObject
        if ( proxy ) {

            // QProperties
            TQStrList propList( mo->propertyNames( true ) );
            for ( TQStrListIterator iter1( propList ); iter1.current(); ++iter1 ) {

                TQCString name = iter1.current();
                int propid = mo->findProperty( name.data(), true );
                if ( propid == -1 )
                    continue;
                returnList << name;
            }

            // Slots
            KJS::List items;
            TQStrList slotList( mo->slotNames( true ) );

            for ( TQStrListIterator iter2( slotList ); iter2.current(); ++iter2 ) {
                TQCString name = iter2.current();
                TQString nm( name );

                int slotid = mo->findSlot( name.data(), true );
                if ( slotid != -1 ) {
                    returnList << nm;
                }
            }
        }
        return returnList;
    }

    TQString dumpObject( KJS::ExecState *exec, KJS::Object &obj ) {
        if ( !obj.isValid() )
            return TQString( "Invalid object\n" );

        TQStringList properties;
        TQStringList methods;

        KJS::ReferenceList l = obj.propList( exec, true );
        KJS::ReferenceListIterator propIt = l.begin();

        while ( propIt != l.end() ) {

            KJS::Identifier name = propIt->getPropertyName( exec );

            if ( obj.hasProperty( exec, name ) ) {

                KJS::Value v = obj.get( exec, name );
                KJS::Object vobj = v.toObject( exec );
                TQString nm( name.ustring().qstring() );

                kdDebug( 80001 ) << "Getting: " << name.ustring().qstring() << " "
                << vobj.prototype().toString( exec ).qstring() << endl;

                if ( vobj.implementsConstruct() ) {
                    // Do nothing
                    kdDebug( 80001 ) << "implementsConstruct: " << nm << endl;
                    if ( vobj.prototype().toString( exec ).qstring() == "[function]" )
                        methods += nm;
                } else if ( vobj.implementsCall() ) {
                    kdDebug( 80001 ) << "implementsCall: " << nm << endl;
                    methods += nm;
                } else {
                    properties += nm;
                }
            }

            propIt++;
        }

        TQString s;

        // JS properties
        s += TQString( "<h2>Properties</h2>\n" );

        if ( !properties.isEmpty() ) {
            s += "<table width=\"90%\">\n";
            s += "<tr><th>Type</th><th>Name</th><th>Value</th></tr>\n";

            properties.sort();
            for ( TQStringList::Iterator iter = properties.begin(); iter != properties.end(); ++iter ) {
		KJS::Value v = obj.get( exec, KJS::Identifier( KJS::UString( *iter ) ) );
                TQVariant val = convertToVariant( exec, v );

                s += TQString( "<tr><td align=\"center\">%1</td><td><b>%2</b></td><td align=\"center\">%3</td></tr>\n" )
                     .arg( val.typeName() ).arg( *iter ).arg( val.toString() );
            }

            s += "</table>\n";
        } else
            s += "<i>None</i>\n";

        // Methods
        s += TQString( "<h2>Methods</h2>\n" );

        if ( !methods.isEmpty() ) {
            s += "<table width=\"90%\">";
            methods.sort();
            for ( TQStringList::Iterator iter = methods.begin(); iter != methods.end(); ++iter ) {
                s += "<tr><td><b>";
                s += *iter;
                s += "(...)</b></td></tr>";
            }
            s += "</table>";
        } else
            s += "<i>None</i>\n";

        s += dumpQObject( exec, obj );
        return s;
    }

    TQString dumpQObject( KJS::ExecState * /*exec*/, KJS::Object &obj ) {
        if ( !obj.isValid() )
            return TQString( "Invalid object\n" );

        TQString s( "" );
        JSObjectProxy *proxy = JSProxy::toObjectProxy( obj.imp() );
        TQObject *qo = proxy ? proxy->object() : 0;
        TQMetaObject *mo = qo ? qo->metaObject() : 0;

        // QObject
        if ( proxy ) {

            // QProperties
            s += TQString( "<h2>Qt Properties</h2>\n" );

            TQStrList propList( mo->propertyNames( true ) );

            if ( !propList.isEmpty() ) {

                s += "<table width=\"90%\">\n";
                s += "<tr><th>Type</th><th>Name</th><th>Value</th></tr>\n";

                propList.sort();
                for ( TQStrListIterator iter( propList ); iter.current(); ++iter ) {

                    TQCString name = iter.current();
                    int propid = mo->findProperty( name.data(), true );
                    if ( propid == -1 )
                        continue;

                    TQVariant vl = qo->property( name.data() );
                    s += TQString( "<tr><td align=\"center\">%1</td><td><b>%2</b></td><td align=\"center\">%3</td></tr>\n" )
                         .arg( mo->property( propid, true ) ->type() ).arg( name ).arg( vl.toString() );
                }

                s += "</table>\n";
            } else {
                s += "<i>None</i>";
            }

            // Signals
            s += TQString( "<h2>Qt Signals</h2>\n" );
            s += "<table width=\"90%\">";

            TQStrList signalList( mo->signalNames( true ) );
            signalList.sort();

            for ( TQStrListIterator iter1( signalList ); iter1.current(); ++iter1 ) {

                TQCString name = iter1.current();
                TQString nm( name );

                int signalid = mo->findSignal( name.data(), true );
                if ( signalid != -1 )
                    s += TQString( "<tr><td><b>%1</b></td></tr>\n" ).arg( nm );
            }

            s += "</table>";
            if ( signalList.isEmpty() )
                s += "<i>None</i>";

            // Slots
            s += TQString( "<h2>Qt Slots</h2>\n" );
            s += "<table width=\"90%\">";

            KJS::List items;
            TQStrList slotList( mo->slotNames( true ) );
            slotList.sort();

            for ( TQStrListIterator iter2( slotList ); iter2.current(); ++iter2 ) {

                TQCString name = iter2.current();
                TQString nm( name );

                int slotid = mo->findSlot( name.data(), true );
                if ( slotid != -1 ) {
                    const QMetaData * md = mo->slot( slotid, true );
                    const QUMethod *method = md->method;
                    if ( method->count && ( method->parameters->inOut == QUParameter::Out ) ) {
                        TQCString typenm( method->parameters->type->desc() );
                        if ( typenm == "ptr" ) {
                            s += TQString( "<tr><td>%1</td><td><b>%2</b></td></tr>\n" )
                                 .arg( ( const char * ) method->parameters->typeExtra ).arg( nm );
                        } else {
                            s += TQString( "<tr><td>%1</td><td><b>%2</b></td></tr>\n" )
                                 .arg( typenm.data() ).arg( nm );
                        }
                    } else
                        s += TQString( "<tr><td>void</td><td><b>%1</b></td></tr>\n" ).arg( nm );
                }
            }

            s += "</table>";
            if ( slotList.isEmpty() )
                s += "<i>None</i>";
        }

        return s;
    }



    TQPen extractQPen( KJS::ExecState *exec, const KJS::List &args, int idx ) {
        return ( args.size() > idx ) ? convertToVariant( exec, args[ idx ] ).toPen() : TQPen();
    }

    TQBrush extractQBrush( KJS::ExecState *exec, const KJS::List &args, int idx ) {
        return ( args.size() > idx ) ? convertToVariant( exec, args[ idx ] ).toBrush() : TQBrush();
    }

    TQFont extractQFont( KJS::ExecState *exec, const KJS::List &args, int idx ) {
        return ( args.size() > idx ) ? convertToVariant( exec, args[ idx ] ).toFont() : TQFont();
    }

    TQPixmap extractQPixmap( KJS::ExecState *exec, const KJS::List &args, int idx ) {
        return ( args.size() > idx ) ? convertToVariant( exec, args[ idx ] ).toPixmap() : TQPixmap();
    }

    TQImage extractQImage( KJS::ExecState *exec, const KJS::List &args, int idx ) {
        return ( args.size() > idx ) ? convertToVariant( exec, args[ idx ] ).toImage() : TQImage();
    }

    TQPalette extractQPalette( KJS::ExecState *exec, const KJS::List &args, int idx ) {
        return ( args.size() > idx ) ? convertToVariant( exec, args[ idx ] ).toPalette() : TQPalette();
    }

    TQString extractQString( KJS::ExecState *exec, const KJS::List &args, int idx ) {
        return ( args.size() > idx ) ? args[ idx ].toString( exec ).qstring() : TQString::null;
    }

    int extractInt( KJS::ExecState *exec, const KJS::List &args, int idx ) {
        return ( args.size() > idx ) ? args[ idx ].toInteger( exec ) : 0;
    }

    TQColor extractQColor( KJS::ExecState *exec, const KJS::List &args, int idx ) {
        return ( args.size() > idx ) ? convertToVariant( exec, args[ idx ] ).toColor() : TQColor();
    }

    TQSize extractQSize( KJS::ExecState *exec, const KJS::List &args, int idx ) {
        return ( args.size() > idx ) ? convertToVariant( exec, args[ idx ] ).toSize() : TQSize();
    }

    bool extractBool( KJS::ExecState *exec, const KJS::List &args, int idx ) {
        return ( args.size() > idx ) ? args[ idx ].toBoolean( exec ) : false;
    }

    double extractDouble( KJS::ExecState *exec, const KJS::List &args, int idx ) {
        return ( args.size() > idx ) ? args[ idx ].toNumber( exec ) : 0.0;
    }

    uint extractUInt( KJS::ExecState *exec, const KJS::List &args, int idx ) {
        return ( args.size() > idx ) ? args[ idx ].toUInt32( exec ) : 0;
    }

    TQStringList extractQStringList( KJS::ExecState *exec, const KJS::List &args, int idx ) {
        return ( args.size() > idx ) ? convertArrayToStringList( exec, args[ idx ] ) : TQStringList();
    }

    /**
    * This will return if the value is a list, associative array or neither
    * @return 
    */

    JavaScriptArrayType checkArray( KJS::ExecState *exec, const KJS::Value &val ) {
        KJS::Object obj = val.toObject( exec );
        kdDebug( 80001 ) << "Object type: " << obj.className().qstring() << endl;
        if ( obj.className().qstring() == "Array" ) {
            //KJS::ReferenceList lst = obj.propList( exec, true );
            KJS::Value len = obj.get(exec, KJS::Identifier("length"));
            kdDebug(80001) << "Array length: " << len.toNumber(exec) << endl;
            kdDebug(80001) << "Object type: " << len.type() << endl;
	    char buff[4];
            if( !obj.hasProperty(exec, KJS::Identifier("length")) )
                return Map;
            else if( !obj.hasProperty(exec, KJS::Identifier( itoa((len.toNumber(exec) - 1), buff, 10 ) ) ) )
                return Map;
            /*
            if( obj.get(exec, KJS::Identifier("length")).toInteger(exec) == 0 )
                return List;
            int offset = 0;
            KJS::ReferenceListIterator idx = lst.begin();
            for ( ; idx != lst.end(); idx++ ) {
                if ( idx->getPropertyName( exec ).qstring().toInt() != offset )
                    return Map;
                offset++;
                kdDebug( 80001 ) << "Property Name: " << idx->getPropertyName( exec ).qstring() << endl;
                kdDebug( 80001 ) << "Property Value: " << idx->getValue( exec ).toString( exec ).qstring() << endl;
            }
            */
            else
                return List;
        } else
            return None;
    }

    TQMap<TQString, TQVariant> convertArrayToMap( KJS::ExecState *exec, const KJS::Value &value ) {
        TQMap<TQString, TQVariant> returnMap;
          KJS::Object obj = value.toObject(exec);
//          if( obj.className().qstring() == "Array" ) {
            KJS::ReferenceList lst = obj.propList(exec,false);
            KJS::ReferenceListIterator idx = lst.begin();
            for( ; idx != lst.end(); idx++ )
            {
              KJS::Identifier id = idx->getPropertyName(exec);
              KJS::Value val = idx->getValue(exec);
              returnMap.insert(id.qstring(),convertToVariant(exec,val));
            }
//          }
        return returnMap;
    }

    TQValueList<TQVariant> convertArrayToList( KJS::ExecState *exec, const KJS::Value &value ) {
        TQValueList<TQVariant> returnList;
        KJS::Object obj = value.toObject( exec );
        if ( obj.className().qstring() == "Array" ) {
            int length = obj.get( exec, KJS::Identifier( "length" ) ).toInteger( exec );
            for ( int index = 0; index < length; ++index ) {
                char buff[4];
                KJS::Value val = obj.get(exec, KJS::Identifier( itoa( index, buff, 10 ) ) );
                if( val.isValid() )
                    returnList += convertToVariant(exec, val );
                else
                    returnList += "";
            }
        }
        return returnList;
    }

    TQStringList convertArrayToStringList( KJS::ExecState *exec, const KJS::Value &value ) {
        TQStringList returnList;
        KJS::Object obj = value.toObject( exec );
        if ( obj.className().qstring() == "Array" ) {
            int length = obj.get( exec, KJS::Identifier( "length" ) ).toInteger( exec );
            for ( int index = 0; index < length; ++index ) {
                char buff[4];
                KJS::Value val = obj.get(exec, KJS::Identifier( itoa( index, buff, 10 ) ) );

                if( val.isValid() )
                    returnList +=  val.toString(exec).qstring();
                else
                    returnList += "";
                }
        }
        return returnList;
    }
/*
    TQStringList convertArrayToStringList( KJS::ExecState *exec, const KJS::Value &value ) {
        TQStringList returnList;
        KJS::Object obj = value.toObject( exec );

        if ( obj.className().qstring() == "Array" ) {
            int length = obj.get( exec, KJS::Identifier( "length" ) ).toInteger( exec );
            for ( int index = 0; index < length; ++index ) {
                returnList << obj.get( exec, KJS::Identifier( KJS::UString::from( index ) ) ).toString( exec ).qstring();
            }
        }

        return returnList;
    }
*/
    TQDateTime convertDateToDateTime( KJS::ExecState *exec, const KJS::Value &value ) {
        KJS::List args;
        TQDateTime returnDateTime;
        KJS::Object obj = value.toObject( exec );

        if ( obj.className().qstring() == "Date" ) {
            int seconds = obj.get( exec, KJS::Identifier( "getSeconds" ) ).toObject( exec ).call( exec, obj, args ).toInteger( exec );
            int minutes = obj.get( exec, KJS::Identifier( "getMinutes" ) ).toObject( exec ).call( exec, obj, args ).toInteger( exec );
            int hours = obj.get( exec, KJS::Identifier( "getHours" ) ).toObject( exec ).call( exec, obj, args ).toInteger( exec );
            int month = obj.get( exec, KJS::Identifier( "getMonth" ) ).toObject( exec ).call( exec, obj, args ).toInteger( exec );
            int day = obj.get( exec, KJS::Identifier( "getDate" ) ).toObject( exec ).call( exec, obj, args ).toInteger( exec );
            int year = obj.get( exec, KJS::Identifier( "getFullYear" ) ).toObject( exec ).call( exec, obj, args ).toInteger( exec );

            returnDateTime.setDate( TQDate( year, month + 1, day ) );
            returnDateTime.setTime( TQTime( hours, minutes, seconds ) );
        } else {
            kdWarning() << "convertDateToDateTime() received a " << obj.className().qstring() << " instead of a Date" << endl;
        }

        return returnDateTime;
    }

    TQDateTime extractQDateTime( KJS::ExecState * exec, const KJS::List & args, int idx ) {
        return ( args.size() > idx ) ? convertDateToDateTime( exec, args[ idx ] ) : TQDateTime();
    }

    TQDate extractQDate( KJS::ExecState * exec, const KJS::List & args, int idx ) {
        return ( args.size() > idx ) ? convertDateToDateTime( exec, args[ idx ] ).date() : TQDate();
    }

    TQTime extractQTime( KJS::ExecState * exec, const KJS::List & args, int idx ) {
        return ( args.size() > idx ) ? convertDateToDateTime( exec, args[ idx ] ).time() : TQTime();
    }

    TQRect extractQRect( KJS::ExecState * exec, const KJS::List & args, int idx ) {
        return ( args.size() > idx ) ? convertToVariant( exec, args[ idx ] ).toRect() : TQRect();
    }

    TQPoint extractQPoint( KJS::ExecState * exec, const KJS::List & args, int idx ) {
        return ( args.size() > idx ) ? convertToVariant( exec, args[ idx ] ).toPoint() : TQPoint();
    }

    TQStrList extractQStrList( KJS::ExecState *exec, const KJS::List &args, int idx ) {
        return ( args.size() > idx ) ? convertArrayToStrList( exec, args[ idx ] ) : TQStrList();
    }

    TQStrList convertArrayToStrList( KJS::ExecState *exec, const KJS::Value &value ) {
        TQStrList returnList;
        KJS::Object obj = value.toObject( exec );

        if ( obj.className().qstring() == "Array" ) {
            int length = obj.get( exec, KJS::Identifier( "length" ) ).toInteger( exec );
            for ( int index = 0; index < length; ++index ) {
                returnList.append( obj.get( exec, KJS::Identifier( KJS::UString::from( index ) ) ).toString( exec ).qstring().latin1() );
            }
        }

        return returnList;
    }

    TQObject *extractQObject( KJS::ExecState *exec, const KJS::List &args, int idx ) {
        KJS::Object obj = args[ idx ].toObject( exec );
        JSObjectProxy *proxy = JSProxy::toObjectProxy( obj.imp() );
        if ( !proxy )
            return 0L;
        return proxy->object();

    }

    TQWidget *extractQWidget( KJS::ExecState *exec, const KJS::List &args, int idx ) {
        KJS::Object obj = args[ idx ].toObject( exec );
        JSObjectProxy *proxy = JSProxy::toObjectProxy( obj.imp() );
        if ( !proxy )
            return 0L;
        return proxy->widget();
    }

    JSOpaqueProxy *extractOpaqueProxy( KJS::ExecState *exec, const KJS::List &args, int idx ) {
        KJS::Object obj = args[ idx ].toObject( exec );
        return JSProxy::toOpaqueProxy( obj.imp() );
    }

    KJS::Object throwError( KJS::ExecState *exec, const TQString &error, KJS::ErrorType type )
    {
        int sourceId = exec->context().sourceId();
        int startLine = exec->context().curStmtFirstLine();
        
        KJS::Object retValue = KJS::Error::create( exec, type, error.utf8(), startLine, sourceId );
        kdWarning(80001) << error << endl;
        exec->setException( retValue );
        return retValue;
    }
} // namespace KJSEmbed

