/*
    This file is part of KOrganizer.

    Copyright (c) 2001 Cornelius Schumacher <schumacher@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of Qt, and distribute the resulting executable,
    without including the source code for Qt in the source distribution.
*/
#ifndef TIMELINE_H
#define TIMELINE_H

#include <tqscrollview.h>
#include <tqdatetime.h>

class TimeLine : public QScrollView
{
    Q_OBJECT
  public:
    TimeLine( TQWidget *parent = 0, const char *name = 0 );
    virtual ~TimeLine();

    void setDateRange( const TQDateTime &start, const TQDateTime &end );

  public slots:
    void setContentsPos( int pos );

  protected:
    void drawContents(TQPainter* p, int cx, int cy, int cw, int ch);

  private:
    TQDateTime mStartDate;
    TQDateTime mEndDate;

    int mPixelWidth;
    int mDaySpacing;
    int mDayOffset;
    int mSecsPerPixel;
};

#endif

