/* -*- Mode: C++ -*-
   $Id: KDGanttViewEventItem.h 1157655 2010-07-31 19:53:50Z tpearson $
   KDGantt - a multi-platform charting engine
*/

/****************************************************************************
 ** Copyright (C)  2001-2004 Klarlvdalens Datakonsult AB.  All rights reserved.
 **
 ** This file is part of the KDGantt library.
 **
 ** This file may be distributed and/or modified under the terms of the
 ** GNU General Public License version 2 as published by the Free Software
 ** Foundation and appearing in the file LICENSE.GPL included in the
 ** packaging of this file.
 **
 ** Licensees holding valid commercial KDGantt licenses may use this file in
 ** accordance with the KDGantt Commercial License Agreement provided with
 ** the Software.
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **
 ** See http://www.klaralvdalens-datakonsult.se/Public/products/ for
 **   information about KDGantt Commercial License Agreements.
 **
 ** Contact info@klaralvdalens-datakonsult.se if any conditions of this
 ** licensing are not clear to you.
 **
 ** As a special exception, permission is given to link this program
 ** with any edition of Qt, and distribute the resulting executable,
 ** without including the source code for Qt in the source distribution.
 **
 **********************************************************************/

#ifndef KDGANTTVIEWEVENTITEM_H
#define KDGANTTVIEWEVENTITEM_H

#include "KDGanttViewItem.h"

class KDGanttViewEventItem : public KDGanttViewItem
{
public:
    KDGanttViewEventItem( KDGanttView* view,
                          const TQString& lvtext = TQString::null,
                         const TQString& name = TQString::null );
    KDGanttViewEventItem( KDGanttViewItem* parent,
                          const TQString& lvtext = TQString::null,
                         const TQString& name = TQString::null );
    KDGanttViewEventItem( KDGanttView* view, KDGanttViewItem* after,
                          const TQString& lvtext = TQString::null,
                         const TQString& name = TQString::null );
    KDGanttViewEventItem( KDGanttViewItem* parent, KDGanttViewItem* after,
                          const TQString& lvtext = TQString::null,
                         const TQString& name = TQString::null );
    virtual ~KDGanttViewEventItem();

    void setLeadTime( const TQDateTime& leadTimeStart );
    void setStartTime( const TQDateTime& start );
    TQDateTime leadTime() const;

private:
    void showItem( bool show = true, int coordY = 0 );
    TQDateTime* myLeadTime;
    void initItem();
    void hideMe();
};

#endif
