/*
 *  Copyright (c) 2002-2003 Jesper K. Pedersen <blackie@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License version 2 as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 **/
#ifndef __textregexp_h
#define __textregexp_h

#include "regexp.h"

/**
   Abstract syntax node for `text' regular expression
   @internal
*/
class TextRegExp :public RegExp
{
public:
	TextRegExp( bool selected, TQString text = TQString::null);

    virtual bool check( ErrorMap&, bool first, bool last );
    virtual int precedence() const {
        if ( _text.length() > 1 )
            return 2;
        else
            return 4;
    }
    TQString text() const { return _text; }
    virtual TQDomNode toXml( TQDomDocument* doc ) const;
    virtual bool load( TQDomElement, const TQString& version );
    void append( TQString str);
    virtual RegExpType type() const { return TEXT;}
    virtual bool operator==( const RegExp& other ) const;

private:
	TQString _text;
};

#endif // __textregexp_h
