/*
 * tools_p.cpp
 *
 * Copyright (c) 2001, 2002, 2003, 2004 Frerich Raabe <raabe@kde.org>
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. For licensing and distribution details, check the
 * accompanying file 'COPYING'.
 */
#include "tools_p.h"

#include <tqdom.h>

TQString RSS::extractNode(const TQDomNode &parent, const TQString &elemName)
{
	TQDomNode node = parent.namedItem(elemName);
	if (node.isNull())
		return TQString::null;

	TQString result = node.toElement().text().simplifyWhiteSpace();
	if (result.isEmpty())
		return TQString::null;

	return result;
}

// vim:noet:ts=4
