/*
 * main.cpp for lisa,reslisa,kio_lan and kio_rlan kcm module
 *
 *  Copyright (C) 2000 Alexander Neundorf <neundorf@kde.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef LISA_SETUPWIZARD_H
#define LISA_SETUPWIZARD_H

#include "kcmlisa.h"
#include "kcmreslisa.h"
#include "kcmkiolan.h"

#include "findnic.h"

#include <tqspinbox.h>
#include <tqcheckbox.h>
#include <krestrictedline.h>
#include <tqwizard.h>
#include <kglobal.h>
#include <tqlayout.h>
#include <tqlabel.h>
#include <tqlistbox.h>
#include <tqvbox.h>

#include <kcmodule.h>


class SetupWizard:public QWizard
{
   Q_OBJECT
   public:
      SetupWizard(TQWidget* parent, LisaConfigInfo* configInfo);
      ~SetupWizard();
      virtual void showPage(TQWidget* page);
      void clearAll();
   protected slots:
      virtual void next();
      virtual void accept();
      void checkIPAddress(const TQString& address);
   protected:
      void applyLisaConfigInfo(LisaConfigInfo& lci);

      void setupPage1();
      void setupNoNicPage();
      void setupMultiNicPage();
      void setupSearchPage();
      void setupAddressesPage();
      void setupAllowedPage();
      void setupBcastPage();
      void setupUpdateIntervalPage();
      void setupAdvancedSettingsPage();
      void setupFinalPage();
      void setupRest();

      TQVBox* m_page1;
      TQVBox* m_noNicPage;
      TQVBox* m_multiNicPage;
      TQVBox* m_searchPage;
      TQVBox* m_addressesPage;
      TQVBox* m_allowedAddressesPage;
      TQVBox* m_bcastPage;
      TQVBox* m_intervalPage;
      TQVBox* m_advancedPage;
      TQVBox* m_finalPage;


      TQListBox *m_nicListBox;
      TQLabel *m_trustedHostsLabel;
      TQCheckBox *m_ping;
      TQCheckBox *m_nmblookup;
      KRestrictedLine* m_pingAddresses;
      KRestrictedLine* m_allowedAddresses;
      KRestrictedLine* m_bcastAddress;
      KRestrictedLine* m_manualAddress;
      TQSpinBox* m_updatePeriod;
      TQCheckBox* m_deliverUnnamedHosts;
      TQSpinBox* m_firstWait;
      TQSpinBox* m_maxPingsAtOnce;
      TQCheckBox* m_secondScan;
      TQSpinBox* m_secondWait;

      NICList* m_nics;
      LisaConfigInfo* m_configInfo;
};


#endif

