/*
 * portsettingsbar.h
 *
 * Copyright (c) 2000, 2005 Alexander Neundorf <neundorf@kde.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef PORTSETTINGSBAR_H
#define PORTSETTINGSBAR_H

#include <tqhbox.h>
#include <tqcombobox.h>

#define PORTSETTINGS_CHECK 0
#define PORTSETTINGS_PROVIDE 1
#define PORTSETTINGS_DISABLE 2

class PortSettingsBar:public QHBox
{
   Q_OBJECT
   public:
      PortSettingsBar(const TQString& title, TQWidget *parent=0);
      virtual ~PortSettingsBar() {};
      int selected() const;
      void setChecked(int what);
   signals:
      void changed();
   protected:
      TQComboBox *m_box;
};

#endif
