/*
 * Main controller for:
 *
 * PUKE = Perl gUi Kontrol Environment
 *
 */

#ifndef PUKE_CONTROLLER_H
#define PUKE_CONTROLLER_H

#include <tqobject.h>
#include <tqsocketnotifier.h>
#include <tqstring.h>
#include <tqdict.h>
#include <tqintdict.h>
#include <tqstrlist.h>

#include "pmessage.h"
#include "pobject.h"
#include "pwidget.h"
#include "commands.h"

class PukeController;
class KLibrary;

typedef struct {
  TQString server;
  bool writeable;
  TQSocketNotifier *sr,*sw;
} fdStatus;


struct commandStruct {
  void (PukeController::*cmd)(int, PukeMessage*);
  KLibrary *library;
};

typedef struct {
  PObject *pwidget; // The widget
  int type;         // The type so casting is "safer"
} WidgetS;          // WidgetStruct

typedef struct {
  PObject *(*wc)(CreateArgs &ca);
  KLibrary *library;
} widgetCreate;

class errorNoSuchWidget {
public:
  errorNoSuchWidget(widgetId &_wi)
  {
    wi = _wi;
  }

  widgetId &widgetIden() {
    return wi;
  }
private:
  widgetId wi;
};

class errorCommandFailed {
public:
    errorCommandFailed(int _command, int _iarg){
        __command = _command;
        __iarg = _iarg;
    }

    int command() { return __command; }
    int iarg() { return __iarg; }
    
private:
    int __command, __iarg;
};

#define INVALID_DEL_NO_CONTROL 100
#define INVALID_DEL_NO_SUCH_CONNECTION 101
#define INVALID_DEL_NO_SUCH_WIDGET 102

class PukeController : public PObject
{
  Q_OBJECT
public:
  PukeController(TQString socket = "", TQObject *parent=0, const char *name=0);
  virtual ~PukeController();
  bool running;

  /**
   * Verifies the widgetId exists and is a valid widget.
   * True is valid, false if invalid.
   */
  bool checkWidgetId(widgetId *pwI);

  /**
   * id2pobject takes a window id and returns the reuired object
   * it throw an errorNoSuchWidget on failures
   */
  PObject *id2pobject(int fd, int iWinId);
  PObject *id2pobject(widgetId *pwi);
  /**
   * Return a PWidget if it's a widget, throws an exception if not found
   */
  PWidget *id2pwidget(widgetId *pwi);

  TQStrList allObjects();

signals:
  void PukeMessages(TQString server, int command, TQString args);
  void inserted(TQObject *);

public slots:
  void ServMessage(TQString, int, TQString);

protected slots:
  void Traffic(int);
  void Writeable(int);
  void NewConnect(int);
  void slotInserted(TQObject *obj);

  /**
   * When we delete a widget, this removes it from our internal
   * list of widgets.  We never remove a widget ourselfs, we call delete
   * and this function removes it.
   */
  void pobjectDestroyed();

  /**
   * Fd to write to
   * PukeMessage message  to be written, if null buffer is flushed.
   */
  void writeBuffer(int fd, PukeMessage *message);


private:
  TQString qsPukeSocket;
  int iListenFd;
  bool bClosing; // Set true if we are closing, we don't try and close twice at the same time.
  TQSocketNotifier *qsnListen;
  TQIntDict<fdStatus> qidConnectFd;

  /**
   * Controller ID is defined as 1
   */
  enum { ControllerWinId = PUKE_CONTROLLER };
      
  
  // List of widgets and the fle descriptors they belong too
  TQIntDict<TQIntDict<WidgetS> > WidgetList;
  // I use a char * key that's the %p (hex address) of the pwidget
  TQDict<widgetId> revWidgetList;
  enum { keySize = 10 };

  // Funtions used to create new widget
  TQIntDict<widgetCreate> widgetCF; // widgetCreatingFuntion List

  TQIntDict<commandStruct> qidCommandTable;

  void initHdlr();

  void closefd(int fd);

  void MessageDispatch(int fd, PukeMessage *pm);

  /**
   * WinId comes from a static unsigned int we increment for each new window
   */
  static uint uiBaseWinId;
  
  /**
   * Create new Widget, returns new iWinId for it.
   * Takes server fd and parent winid, and type as arguments
   */
  widgetId createWidget(widgetId wI, PukeMessage *pm);

  /**
   * Used to process messages going to controller, winId #1
   *
   */
  void messageHandler(int fd, PukeMessage *pm);

  /**
   * NOT APPLICAABLE
   */
  void setWidget(TQObject *) { }
  /**
   * NOT APPLICAABLE
   */
  virtual TQObject *widget() { return 0x0; }

  /**
   * Inserts a PObject into our internal list
   */
  void insertPObject(int fd, int iWinId, WidgetS *obj);

  /**
   * Closes a widget, checking for sanity
   */
//  void closeWidget(widgetId wI);
   
  // Message handlers
  void hdlrPukeSetup(int fd, PukeMessage *pm);
  void hdlrPukeInvalid(int fd, PukeMessage *pm);
  void hdlrPukeEcho(int fd, PukeMessage *pm);
  void hdlrPukeDumpTree(int fd, PukeMessage *pm);
  void hdlrPukeFetchWidget(int fd, PukeMessage *pm);
  void hdlrPukeDeleteWidget(int fd, PukeMessage *pm);

};

#endif

