/* This file is part of the KDE project
   Copyright (C) 2001 Simon Hausmann <hausmann@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the Artistic License.
*/
#ifndef __logfile_h__
#define __logfile_h__

#include <tqobject.h>

class TQFile;

class LogFile : public QObject
{
public:
    LogFile( const TQString &channel, const TQString &server );
    virtual ~LogFile();

    void open();

    void closeLog();

    void log( const TQString &message );

protected:
    virtual void timerEvent( TQTimerEvent * );

private:
    TQString m_channel;
    TQString m_server;

    TQFile *m_file;

    int m_flushTimerId;

    TQString makeLogFileName( const TQString &channel, const TQString &server, int suffix = -1 );
};

#endif
