/* This file is part of the KDE project
   Copyright (C) 2001 Simon Hausmann <hausmann@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the Artistic License.
*/
#ifndef __ksparser_h__
#define __ksparser_h__

#include <tqstring.h>
#include <tqmap.h>
#include <tqcolor.h>
#include <tqvaluestack.h>

// Helper class to parse IRC colour/style codes and convert them to
// richtext. The parser maintains an internal stack of the styles
// applied because the IRC message could contain sequences as
// (bold)Hello (red)World(endbold)! (blue)blue text
// which needs to be converted to
// <b>Hello </b><font color="red"><b>World</b>! </font><font color="blue">blue text</font>
// to get correctly nested tags. (malte)
class KSParser
{
public:
    TQString parse(const TQString &);
    bool beeped() const { return m_beeped; }

private:
    TQString pushTag(const TQString &, const TQString & = TQString::null);
    TQString popTag(const TQString &);
    TQString toggleTag(const TQString &, const TQString & = TQString::null);
    TQString popAll();
    TQColor ircColor(int);

private:
    TQValueStack<TQString> m_tags;
    TQMap<TQString, TQString> m_attributes;
    bool m_beeped;
};

#endif


