#ifndef KSIRCCHANNEL_H
#define KSIRCCHANNEL_H

#include <tqstring.h>

class KSircChannel
{

public:
  KSircChannel( const TQString server,
		const TQString channel,
		const TQString key = TQString::null,
		  const TQString encoding = TQString::null
		) :
  m_server(server), m_channel(channel),
  m_key(key), m_encoding(encoding) {}

  const TQString server() const   { return m_server; }
  const TQString channel() const  { return m_channel; }
  const TQString key() const      { return m_key; }
  const TQString encoding() const { return m_encoding; }

  void setChannel(TQString channel) { m_channel = channel; }
  void setKey(TQString key) { m_key = key; }
  void setEncoding(TQString encoding) { m_encoding = encoding; }

private:
  const TQString m_server; /* channels can never change server */
  TQString     m_channel;
  TQString     m_key;
  TQString     m_encoding;

};

#endif
