/* This file is part of the KDE project
   Copyright (C) 2001 Simon Hausmann <hausmann@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/
#ifndef __colorpicker_h__
#define __colorpicker_h__

#include <tqvaluevector.h>
#include <tqcolor.h>

#include <kdialogbase.h>

class TQLineEdit;

class ColorPicker : public KDialogBase
{
    Q_OBJECT
public:
    ColorPicker( TQWidget *parent, const char *name = 0 );

    TQString colorString() const;

private slots:
    void setForegroundColor( int col );
    void setBackgroundColor( int col );

private:
    void updateSample();

    TQLineEdit *m_sample;
    int m_foregroundColor;
    int m_backgroundColor;
};

class ColorBar : public QFrame
{
    Q_OBJECT
public:
    ColorBar( const TQValueVector<TQColor> &colors, TQWidget *parent, const char *name = 0 );

signals:
    void colorPicked( int col );

protected:
    virtual void drawContents( TQPainter *p );
    virtual void keyPressEvent( TQKeyEvent *ev );
    virtual void focusInEvent( TQFocusEvent *ev );
    virtual void focusOutEvent( TQFocusEvent *ev );
    virtual void fontChange( const TQFont &oldFont );
    virtual void styleChange( TQStyle &oldStyle );
    virtual bool focusNextPrevChild( bool next );
    virtual void mousePressEvent( TQMouseEvent *ev );
    virtual void mouseReleaseEvent( TQMouseEvent *ev );

private:
    void updateCellSize();
    void setCurrentCell( int cell );

    void drawCell( TQPainter *p, int x, int y, const TQColor &color, 
                   const TQString &text, bool isFocusedCell, 
                   bool isCurrentCell );

    int m_currentCell;
    int m_focusedCell;
    const TQValueVector<TQColor> m_colors;
    int m_cellSize;

    // ### style me
    static const int s_indicatorSize = 2;
    static const int s_focusSize = 1;
    static const int s_innerMargin = 1;
};

#endif

/* vim: et sw=4
 */
