/* ascii table for ksirc - Robbie Ward <linuxphreak@gmx.co.uk>*/

#ifndef CHARSELECTOR_H
#define CHARSELECTOR_H

#include <kdialog.h>
#include <kdebug.h>
#include <kcharselect.h>

class TQVBoxLayout;
class TQPushButton;

class charSelector : public KDialog
{
  Q_OBJECT
  public:
    charSelector(TQWidget *parent=0, const char *name=0);
    ~charSelector();

  virtual bool eventFilter ( TQObject * watched, TQEvent * e );

  public slots:
    void insertText();
    TQString currentText() { return charSelect->chr(); }

    void setFont( const TQString &font );

  protected slots:
    virtual void reject();

  signals:
    void clicked();

  protected:
    virtual void keyPressEvent(TQKeyEvent *e);

  private:
    KCharSelect *charSelect;
    TQVBoxLayout* testLayout;
    TQPushButton *insertButton;
};
#endif
