#ifndef ALISTBOX_H
#define ALISTBOX_H

#include <tqlistbox.h>
#include "ksopts.h"

class nickListItem : public QListBoxItem
{
 public:
   nickListItem();
   nickListItem(const nickListItem &old);
   virtual ~nickListItem();

   virtual int height ( const TQListBox * ) const;
   virtual int width ( const TQListBox * ) const;
   TQString text () const { return string; }
   const TQPixmap* pixmap () const;

   bool op() const { return is_op; }
   bool voice() const { return is_voice; }
   bool away() const { return is_away; }
   bool ircOp() const { return is_ircop; }

   void setOp(bool _op = FALSE);
   void setVoice(bool _voice = FALSE);
   void setAway(bool _away = FALSE);
   void setIrcOp(bool _ircop = FALSE);

   void setText(const TQString &str) { string = str; }

   TQString nickPrefix() const;

   void forceColour(const TQColor *col);

   nickListItem &operator= ( const nickListItem & nli );

protected:
  virtual void paint ( TQPainter * );

 private:
  bool is_op:1;
  bool is_voice:1;
  bool is_away:1;
  bool is_ircop:1;

  TQString string;
  const TQColor *forcedCol;
};

class aListBox : public QListBox
{
  Q_OBJECT

public:
  aListBox(TQWidget *parent = 0, const char *name = 0);

  virtual ~aListBox();

  void clear();

  void inSort ( nickListItem *);
  void inSort ( TQString text, bool top=FALSE);

  nickListItem *item(int index);

  bool isTop(int index);

  int findNick(const TQString &str);

  void clearAdvOps();

  bool needNickPrefix() const;

  void setNickListDirty()
  { m_nickListDirty = true; }

  unsigned short int nickPrefixWidth() const
  { return m_nickPrefixWidth; }

  virtual void fontChange( const TQFont &f );

  static TQString nickPrefixOp() { return TQString::fromLatin1( "o" ); }
  static TQString nickPrefixVoice() { return TQString::fromLatin1( "v" ); }
  static TQString nickPrefixAway() { return TQString::fromLatin1( "a" ); }
  static TQString nickPrefixIrcOp() { return TQString::fromLatin1( "O" ); }

signals:
    void contextMenuRequested(int index);
    void selectedNick(const TQString&);
    void urlsDropped( const TQStringList& urls, const TQString& nick );
    void textDropped( const TQListBoxItem *item, const TQString& text );

protected:
  virtual int findSep();
  virtual int searchFor(const TQString &nick, bool &found, bool top);
  virtual void dragMoveEvent( TQDragMoveEvent * );
  virtual void dropEvent( TQDropEvent * );

private slots:
    void reEmitContextMenuRequest( TQListBoxItem *item );

private:
    void updateNeedNickPrefixFlag() const;
    void updateNickPrefixWidth();

    TQPalette p_scroll;
    mutable bool m_nickListDirty;
    mutable bool m_needNickPrefix;
    int m_nickPrefixWidth;
};

#endif
