#ifndef AHISTLINEEDIT_H
#define AHISTLINEEDIT_H

#include <tqtextedit.h>
#include <tqstringlist.h>
#include <tqsize.h>

class aHistLineEdit : public QTextEdit
{
Q_OBJECT
public:
    aHistLineEdit(TQWidget *parent = 0, const char *name = 0);

    int cursorPosition () const;
    void setCursorPosition(int);

    TQString text() const;

signals:
    // Don't use returnPressed from the textEdit
    void gotReturnPressed();
    void gotFocus();
    void lostFocus();
    void pasteText(const TQString&);
    void notTab();
    void resized();

public slots:
    virtual void paste();
    virtual void slotMaybeResize();

protected:
    bool processKeyEvent( TQKeyEvent * );
    virtual void keyPressEvent ( TQKeyEvent * );
    virtual void focusInEvent ( TQFocusEvent * );
    virtual void focusOutEvent ( TQFocusEvent * );
//    virtual void mousePressEvent ( TQMouseEvent * );

    virtual bool eventFilter( TQObject *o, TQEvent *e );

    virtual void paintEvent ( TQPaintEvent * );

private:

    void doEnterKey();

    TQStringList hist;
    TQStringList::Iterator current;
    void ColourPickerPopUp();
    int m_height;

    bool m_drawrect;

};

#endif
