/***************************************************************************
                       hostpreferences.h  -  per host preferences
                             -------------------
    begin                : Fri May 09 19:02 CET 2003
    copyright            : (C) 2003 by Tim Jansen
                         : (C) 2004 Nadeem Hasan <nhasan@kde.org>
    email                : tim@tjansen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef HOSTPREFERENCES_H
#define HOSTPREFERENCES_H

#include <tqstring.h>
#include <tqstringlist.h>
#include "smartptr.h"

class HostPreferences;
class KConfig;

class HostPref {
protected:
	friend class HostPreferences;
	TQString m_host;
	TQString m_type;
	KConfig *m_config;

	HostPref(KConfig *conf, const TQString &host, const TQString &type);

	virtual void load() = 0;
	virtual void setDefaults() = 0;
	virtual void save() = 0;
	virtual void remove() = 0;
public:
	virtual ~HostPref();

	virtual TQString prefDescription() const = 0;
	TQString host() const;
	TQString type() const;
	TQString prefix() const;
	static TQString prefix(const TQString &host, const TQString &type);
};

typedef SmartPtr<HostPref>      HostPrefPtr;
typedef TQValueList<HostPrefPtr> HostPrefPtrList;

class HostPreferences {
public:
	static HostPreferences *instance();
	~HostPreferences();

	HostPrefPtr getHostPref(const TQString &host, const TQString &type);
	HostPrefPtr createHostPref(const TQString &host, const TQString &type);
	HostPrefPtrList getAllHostPrefs();
	HostPrefPtr vncDefaults();
	HostPrefPtr rdpDefaults();
	void removeHostPref(HostPref *hostPref);

	void setShowBrowsingPanel( bool b );
	void setServerCompletions( const TQStringList &list );
	void setServerHistory( const TQStringList &list );

	bool showBrowsingPanel();
	TQStringList serverCompletions();
	TQStringList serverHistory();

	void sync();

private:
	HostPreferences();

	KConfig *m_config;
	static HostPreferences *m_instance;

};

#endif
