/*
 *           kPPP: A pppd front end for the KDE project
 *
 *
 *
 *
 *            Copyright (C) 2004 Simone Gotti
 *               <simone.gotti@email.it>
 *
 * based on EzPPP:
 * Copyright (C) 1997  Jay Painter
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <tqdir.h>
#include <stdlib.h>
#include <tqlayout.h>
#include <tqtabdialog.h>
#include <tqwhatsthis.h>
#include <tqmessagebox.h>

#include <kapplication.h>
#include <kbuttonbox.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <kglobal.h>
#include <kwin.h>
#include <kdialogbase.h>
#include <tqvgroupbox.h>

#include "general.h"
#include "pppdata.h"
#include "modems.h"
#include "accounting.h"
#include "providerdb.h"
#include "edit.h"

void parseargs(char* buf, char** args);

ModemsWidget::ModemsWidget( TQWidget *parent, const char *name )
  : TQWidget( parent, name )
{
  int min = 0;
  TQVBoxLayout *l1 = new TQVBoxLayout(parent, 10, 10);

  // add a hbox
  TQHBoxLayout *l11 = new TQHBoxLayout;
  l1->addLayout(l11);

  modemlist_l = new TQListBox(parent);
  modemlist_l->setMinimumSize(160, 128);
  connect(modemlist_l, TQT_SIGNAL(highlighted(int)),
	  this, TQT_SLOT(slotListBoxSelect(int)));
  connect(modemlist_l, TQT_SIGNAL(selected(int)),
	  this, TQT_SLOT(editmodem()));
  l11->addWidget(modemlist_l, 10);

  TQVBoxLayout *l111 = new TQVBoxLayout;
  l11->addLayout(l111, 1);
  edit_b = new TQPushButton(i18n("&Edit..."), parent);
  connect(edit_b, TQT_SIGNAL(clicked()), TQT_SLOT(editmodem()));
  TQWhatsThis::add(edit_b, i18n("Allows you to modify the selected account"));

  min = edit_b->sizeHint().width();
  min = QMAX(70,min);
  edit_b->setMinimumWidth(min);

  l111->addWidget(edit_b);

  new_b = new TQPushButton(i18n("&New..."), parent);
  connect(new_b, TQT_SIGNAL(clicked()), TQT_SLOT(newmodem()));
  l111->addWidget(new_b);
  TQWhatsThis::add(new_b, i18n("Create a new dialup connection\n"
  			      "to the Internet"));

  copy_b = new TQPushButton(i18n("Co&py"), parent);
  connect(copy_b, TQT_SIGNAL(clicked()), TQT_SLOT(copymodem()));
  l111->addWidget(copy_b);
  TQWhatsThis::add(copy_b,
		  i18n("Makes a copy of the selected account. All\n"
		       "settings of the selected account are copied\n"
		       "to a new account that you can modify to fit your\n"
		       "needs"));

  delete_b = new TQPushButton(i18n("De&lete"), parent);
  connect(delete_b, TQT_SIGNAL(clicked()), TQT_SLOT(deletemodem()));
  l111->addWidget(delete_b);
  TQWhatsThis::add(delete_b,
		  i18n("<p>Deletes the selected account\n\n"
		       "<font color=\"red\"><b>Use with care!</b></font>"));

  //load up account list from gppdata to the list box
  // but keep the current one selected in gpppdata
  if(gpppdata.modemCount() > 0) {
    const TQString currentmodem = gpppdata.modname();
    for(int i=0; i <= gpppdata.modemCount()-1; i++) {
      gpppdata.setModemByIndex(i);
      modemlist_l->insertItem(gpppdata.modname());
    }
    gpppdata.setModem(currentmodem);
  }

  slotListBoxSelect(modemlist_l->currentItem());

  l1->activate();
}



void ModemsWidget::slotListBoxSelect(int idx) {
  delete_b->setEnabled((bool)(idx != -1));
  edit_b->setEnabled((bool)(idx != -1));
  copy_b->setEnabled((bool)(idx != -1));
  if(idx!=-1) {
    TQString modem = gpppdata.modname();
    gpppdata.setModemByIndex(modemlist_l->currentItem());
    gpppdata.setModem(modem);
 }
}

void ModemsWidget::editmodem() {
  gpppdata.setModem(modemlist_l->text(modemlist_l->currentItem()));

  int result = doTab();

  if(result == TQDialog::Accepted) {
    modemlist_l->changeItem(gpppdata.modname(),modemlist_l->currentItem());
    emit resetmodems();
    gpppdata.save();
  }
}


void ModemsWidget::newmodem() {
  if(modemlist_l->count() == MAX_MODEMS) {
      KMessageBox::sorry(this, i18n("Maximum number of modems reached."));
    return;
  }

  int result;

    if (gpppdata.newmodem() == -1)
      return;
    result = doTab();


  if(result == TQDialog::Accepted) {
    modemlist_l->insertItem(gpppdata.modname());
    modemlist_l->setSelected(modemlist_l->findItem(gpppdata.modname()),
			       true);
    emit resetmodems();
    gpppdata.save();
  } else
    gpppdata.deleteModem();
}


void ModemsWidget::copymodem() {
  if(modemlist_l->count() == MAX_MODEMS) {
    KMessageBox::sorry(this, i18n("Maximum number of modems reached."));
    return;
  }

  if(modemlist_l->currentItem()<0) {
    KMessageBox::sorry(this, i18n("No modem selected."));
    return;
  }

  gpppdata.copymodem(modemlist_l->currentItem());

  modemlist_l->insertItem(gpppdata.modname());
  emit resetmodems();
  gpppdata.save();
}


void ModemsWidget::deletemodem() {

  TQString s = i18n("Are you sure you want to delete\nthe modem \"%1\"?")
    .arg(modemlist_l->text(modemlist_l->currentItem()));

  if(KMessageBox::warningContinueCancel(this, s, i18n("Confirm"), KStdGuiItem::del()) != KMessageBox::Continue)
    return;

  if(gpppdata.deleteModem(modemlist_l->text(modemlist_l->currentItem())))
    modemlist_l->removeItem(modemlist_l->currentItem());

  emit resetmodems();
  gpppdata.save();

  slotListBoxSelect(modemlist_l->currentItem());

}


int ModemsWidget::doTab(){
  tabWindow = new KDialogBase( KDialogBase::Tabbed, TQString::null,
                               KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok,
                               0, 0, true);
  KWin::setIcons(tabWindow->winId(), kapp->icon(), kapp->miniIcon());
  bool isnewmodem;

  if(gpppdata.modname().isEmpty()) {
    tabWindow->setCaption(i18n("New Modem"));
    isnewmodem = true;
  } else {
    TQString tit = i18n("Edit Modem: ");
    tit += gpppdata.modname();
    tabWindow->setCaption(tit);
    isnewmodem = false;
  }
  modem1 = new ModemWidget(tabWindow->addPage( i18n("&Device"), i18n("Serial Device")), isnewmodem );
  modem2 = new ModemWidget2(tabWindow->addPage( i18n("&Modem"), i18n("Modem Settings")));
  connect ( modem1->connectName(), TQT_SIGNAL(textChanged ( const TQString & )), this, TQT_SLOT(modemNameChanged(const TQString & )));
  
  modemNameChanged(modem1->connectName()->text());
  int result = 0;
  bool ok = false;
  while (!ok){

    result = tabWindow->exec();
    ok = true;

    if(result == TQDialog::Accepted) {
      if(modem1->save()) {
         modem2->save();
      } else {
        KMessageBox::error(this, i18n( "You must enter a unique\n"
			   "modem name"));
        ok = false;
      }
    }
  }

 delete tabWindow;
 return result;
}

void ModemsWidget::modemNameChanged(const TQString & text)
{
  tabWindow->enableButtonOK( !text.isEmpty() );
}

TQString ModemsWidget::prettyPrintVolume(unsigned int n) {
  int idx = 0;
  const TQString quant[] = {i18n("Byte"), i18n("KB"),
		   i18n("MB"), i18n("GB"), TQString::null};

  float n1 = n;
  while(n >= 1024 && !quant[idx].isNull()) {
    idx++;
    n /= 1024;
  }

  int i = idx;
  while(i--)
    n1 = n1 / 1024.0;

  TQString s = KGlobal::locale()->formatNumber( n1, idx==0 ? 0 : 1 );
  s += " " + quant[idx];
  return s;
}

#include "modems.moc"
