/*
 * kPPPlogview: a accounting log system for kPPP
 *
 *            Copyright (C) 1998 Mario Weilguni <mweilguni@kde.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */


#ifndef __MONTHLY__H__
#define __MONTHLY__H__

#include "log.h"
#include <tqwidget.h>
#include <tqlayout.h>
#include <tqlabel.h>
#include <tqpushbutton.h>
#include <tqvaluelist.h>
#include <tqdatetime.h>

#include <kbuttonbox.h>

class KListView;
class TQComboBox;
class LogListItem;

class MonthlyWidget : public TQWidget {
  Q_OBJECT
public:
  MonthlyWidget(TQWidget *parent = 0);

private slots:
  void prevMonth();
  void nextMonth();
  void currentMonth();
  void slotConnections(int);
  void exportWizard();
  void slotSelectionChanged();

private:
  void layoutWidget();
  void plotMonth();

  /**
   * Returns the first day in the period
   */
  TQDate periodeFirst() const;
  /**
   * Returns the last day in the period
   */
  TQDate periodeLast() const;

  TQDate m_periodeFirst; // First day in month
  //int _month, _year;

  TQComboBox *cboConnections;
  KButtonBox *bbox;
  KListView *lv;
  KListView *lv2;
  LogListItem* selectionItem;
  TQLabel *title;
  TQPushButton *next, *prev, *today, *exportBttn;
  TQValueList<TQString> lstConnections;
  TQGridLayout *tl;
  TQDateTime *dt;
};

#endif
