/*
 * kPPPlogview: a accounting log system for kPPP
 *
 *            Copyright (C) 1998 Mario Weilguni <mweilguni@kde.org>
 *
 * This file has been contributed by Tilo Ulbrich <TiloUlbrich@web.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef KPPPEXPORT_H
#define KPPPEXPORT_H

#include <tqwidget.h>
#include <tqfile.h>
#include <tqlayout.h>
#include <tqlabel.h>
#include <tqlistbox.h>
#include <tqlineedit.h>
#include <tqtooltip.h>

#include <kwizard.h>
#include <klocale.h>
#include <kfiledialog.h>

class Export;

/***** ExportWizard *****/
class ExportWizard : public KWizard {
  Q_OBJECT
public:
   ExportWizard(TQWidget *parent, const TQString &_date);
   Export *createExportFilter();

   int filterID;
   TQString filename;

public slots:
   void typeHighlighted(int);
   void getFilename();

   void accept();
    void reject();

private:
   TQWidget  *formatPage;
   TQListBox *typeList;
   TQLabel   *typeInfo;

   TQWidget     *filenamePage;
   TQLineEdit   *fnLine;
   TQPushButton *fnGet;

   TQString date;
};


/***** Export (abstract)*****/
class Export {
public:
   Export();
   Export(const TQString &filename);
   virtual ~Export();
   bool openFile();
   bool closeFile();
   virtual void addHeadline(const TQString &a, const TQString &b,
			    const TQString &c, const TQString &d,
			    const TQString &e, const TQString &f,
			    const TQString &g, const TQString &h) = 0;
   virtual void addDataline(const TQString &a, const TQString &b,
			    const TQString &c, const TQString &d,
			    const TQString &e, const TQString &f,
			    const TQString &g, const TQString &h) = 0;
   virtual void addEmptyLine() = 0;
   virtual void setFinishCode() = 0;

protected:
   TQFile   file;
   TQString filename;
   TQString buffer;
};


/***** CSVExport *****/
class CSVExport : public Export {
public:
  CSVExport(const TQString &filename, const TQString &separator);
  virtual void addHeadline(const TQString &a, const TQString &b,
			   const TQString &c, const TQString &d,
			   const TQString &e, const TQString &f,
			   const TQString &g, const TQString &h);
  virtual void addDataline(const TQString &a, const TQString &b,
			   const TQString &c, const TQString &d,
			   const TQString &e, const TQString &f,
			   const TQString &g, const TQString &h);
  virtual void addEmptyLine();
  virtual void setFinishCode();

private:
  TQString separator;
};


/***** HTMLExport *****/
class HTMLExport : public Export {
public:
  HTMLExport(const TQString &filename, const TQString &date);
  virtual void addHeadline(const TQString &a, const TQString &b,
			   const TQString &c, const TQString &d,
			   const TQString &e, const TQString &f,
			   const TQString &g, const TQString &h);
  virtual void addDataline(const TQString &a, const TQString &b,
			   const TQString &c, const TQString &d,
			   const TQString &e, const TQString &f,
			   const TQString &g, const TQString &h);
  virtual void addEmptyLine();
  virtual void setFinishCode();

private:
  TQString trStartCode;
  TQString trEndCode;
  TQString tdStartCode;
  TQString tdEndCode;
};

#endif































































