/*
 *
 *            kPPP: A pppd front end for the KDE project
 *
 * $Id: kpppwidget.h 1157648 2010-07-31 19:48:06Z tpearson $
 *
 *            Copyright (C) 1997 Bernd Johannes Wuebben
 *                   wuebben@math.cornell.edu
 *
 *            Copyright (C) 1998-2002 Harri Porten <porten@kde.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef __KPPPWIDGET_H__
#define __KPPPWIDGET_H__

#include <tqstring.h>

#include <dcopclient.h>

#include "accounting.h"
#include "conwindow.h"
#include "accounts.h"
#include "connect.h"
#include "debug.h"
#include "pppstatdlg.h"

#include "KPPPIface.h"

class GeneralWidget;
class ModemsWidget;
class ModemWidget;
class ModemWidget2;
class GraphSetup;
class AboutWidget;
class PPPStats;
class KDialogBase;
class KPushButton;

class SignalEvent : public TQEvent {
public:
  SignalEvent(int s) : TQEvent(User), sig(s) { }
  int sigType() const { return sig; }
private:
  int sig;
};


class KPPPWidget : public TQWidget, virtual public KpppIface {
  Q_OBJECT
public:

  KPPPWidget( TQWidget *parent=0, const char *name=0 );
  ~KPPPWidget();

  void setPW_Edit(const TQString &);
  virtual bool eventFilter(TQObject *, TQEvent *);

  void setQuitOnDisconnect (bool b);
  bool quitOnDisconnect () {return m_bQuitOnDisconnect;};

private slots:
  void newdefaultaccount(int);
	void newdefaultmodem(int);
  void expandbutton();
  void quitbutton();
  void helpbutton();
  void setup();
  void rulesetLoadError();
  void usernameChanged(const TQString &);
  void passwordChanged(const TQString &);
  void enterPressedInID();
  void enterPressedInPW();
  void saveMyself();
  void shutDown();

  void delayedDisconnect();

public slots:
  void beginConnect();
  void resetaccounts();
	void resetmodems();
  void resetCosts(const TQString &);
  void resetVolume(const TQString &);
  void disconnect();
  void log_window_toggled(bool on);
  void startAccounting();
  void stopAccounting();
  void showStats();
  bool isConnected() const {return connected;};
signals:
  void begin_connect();
  void cmdl_start();

public:
  TQCheckBox *log;
  bool connected;
  DebugWidget *debugwindow;
  TQString con_speed;
  ConnectWidget *con;
  ConWindow *con_win;
  PPPStatsDlg *statdlg;
  AccountingBase *acct;
  KPushButton *quit_b;
  PPPStats *stats;

private:
  void prepareSetupDialog();
  void interruptConnection();
  void sigChld();
  void sigPPPDDied();
  TQString encodeWord(const TQString &s);
  void showNews ();
	void setButtons();

  TQString ruleset_load_errmsg;

  TQGridLayout *l1;
  KPushButton *help_b;
  KPushButton *setup_b;
  TQFrame *fline;
  TQFrame *fline1;
  TQPushButton *connect_b;
  TQComboBox *connectto_c;
  TQComboBox *modem_c;
	TQLabel *ID_Label;
  TQLabel *PW_Label;
  TQLineEdit *ID_Edit;
  TQLineEdit *PW_Edit;
  TQLabel *label1;
  TQLabel *label2;
  TQLabel *label3;
  TQLabel *label4;
  TQLabel *label5;
  TQLabel *label6;
	TQLabel *label7;
  TQLabel *radio_label;


  KDialogBase *tabWindow;
  AccountWidget *accounts;
  GeneralWidget *general;
  ModemsWidget *modems;
  GraphSetup *graph;
  AboutWidget *about;


  TQString m_strCmdlAccount;
  TQString m_strCmdlModem;
  bool m_bQuitOnDisconnect;
  bool m_bCmdlAccount;
  bool m_bCmdlModem;
  bool m_bModemCShown;


  TQTimer *disconnectTimer;
};


#endif

