/* -*- C++ -*-
 *
 *            kPPP: A pppd front end for the KDE project
 *
 * $Id: connect.h 1157648 2010-07-31 19:48:06Z tpearson $
 *
 *            Copyright (C) 1997 Bernd Johannes Wuebben
 *                   wuebben@math.cornell.edu
 *
 * based on EzPPP:
 * Copyright (C) 1997  Jay Painter
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef _CONNECT_H_
#define _CONNECT_H_

#include <tqtimer.h>
#include <kpushbutton.h>
#include <tqlabel.h>
#include <tqevent.h>

#include "kpppconfig.h"
#include "pwentry.h"
#include "docking.h"
#include "loginterm.h"

#define MAXLOOPNEST (MAX_SCRIPT_ENTRIES/2)

class PPPStats;

class ConnectWidget : public TQWidget {
  Q_OBJECT
public:
  ConnectWidget(TQWidget *parent, const char *name, PPPStats *st);
  ~ConnectWidget();

public:
  void set_con_speed_string();
  void setMsg(const TQString &);
  void pppdDied();

  // these are only necessary to prevent the user from clicking in the cancel 
  // button during the disconnect delay in KPPPWidget
  void disableButtons();
  void enableButtons();

protected:
  void timerEvent(TQTimerEvent *);
  void closeEvent( TQCloseEvent *e );

private slots:
  void readChar(unsigned char);
  void pause();
  void if_waiting_slot();

public slots:
  void init();
  void preinit();
  void script_timed_out();
  void if_waiting_timed_out();
  void cancelbutton();

signals:
  void if_waiting_signal();
  void debugMessage(const TQString &);
  void toggleDebugWindow();
  void closeDebugWindow();
  void debugPutChar(unsigned char);
  void startAccounting();
  void stopAccounting();

public:
  TQString myreadbuffer;  // we want to keep every thing in order to fish for the

  // connection speed later on
  TQPushButton *debug;
  int main_timer_ID;

private:
  int vmain;
  int substate;
  int scriptindex;
  TQString scriptCommand, scriptArgument;
  TQStringList *comlist, *arglist;

  //  static const int maxloopnest=(MAX_SCRIPT_ENTRIES/2);
  int loopnest;
  int loopstartindex[MAXLOOPNEST];
  bool loopend;
  TQString loopstr[MAXLOOPNEST];

  bool semaphore;
  TQTimer *inittimer;

  TQTimer *timeout_timer;
  bool execppp();
  void writeline(const TQString &);
  void checkBuffers();

  void setExpect(const TQString &);
  bool expecting;
  TQString expectstr;

  TQString readbuffer;

  void setScan(const TQString &);
  TQString scanvar;
  TQString scanstr;
  TQString scanbuffer;
  bool scanning;

  bool pausing;
  PWEntry *prompt;
  LoginTerm *termwindow;

  int scriptTimeout;
  TQTimer *pausetimer;
  TQTimer *if_timer;
  TQTimer *if_timeout_timer;

  TQLabel *messg;
  KPushButton *cancel;

  bool firstrunID;
  bool firstrunPW;

  unsigned int dialnumber; // the current number to dial

  PPPStats *stats;
};


// non-member function to kill&wait on the pppd child process
extern void killppp();
void adddns();
void addpeerdns();
void removedns();
void add_domain(const TQString & newdomain);
void auto_hostname();

#endif

