/*
    Kopete Testbed Protocol

    Copyright (c) 2006 by Cláudio da Silveira Pinheiro   <taupter@gmail.com>
    Kopete    (c) 2002-2006 by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include "testbedwebcamdialog.h"
#include <webcamwidget.h>
#include "avdevice/videodevicepool.h"

#include <tqframe.h>
#include <tqobject.h>
#include <tqwidget.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqvbox.h>
#include <kdebug.h>
#include <klocale.h>

TestbedWebcamDialog::TestbedWebcamDialog( const TQString &contactId, TQWidget * parent, const char * name )
: KDialogBase( KDialogBase::Plain, Qt::WDestructiveClose, parent, name, false, i18n( "Webcam for %1" ).arg( contactId ),
                   KDialogBase::Close, KDialogBase::Close, true /*seperator*/ )
{
	setInitialSize( TQSize(320,290), false );
	
	setEscapeButton( KDialogBase::Close );
//	TQObject::connect( this, TQT_SIGNAL( closeClicked() ), this, TQT_SIGNAL( closingWebcamDialog() ) );

	TQWidget *page = plainPage();
	setMainWidget(page);

	TQVBoxLayout *topLayout = new TQVBoxLayout( page, 0, spacingHint() );	
	mImageContainer = new Kopete::WebcamWidget( page );
	mImageContainer->setMinimumSize(320,240);
	mImageContainer->setText( i18n( "No webcam image received" ) );
	mImageContainer->setSizePolicy(TQSizePolicy::Expanding, TQSizePolicy::Expanding);
	topLayout->add( mImageContainer );
	
	show();
	
	mVideoDevicePool = Kopete::AV::VideoDevicePool::self();
	mVideoDevicePool->open();
	mVideoDevicePool->setSize(320, 240);
	mVideoDevicePool->startCapturing();
	mVideoDevicePool->getFrame();
	mVideoDevicePool->getImage(&mImage);
kdDebug() << "Just captured 1st frame" << endl;

	mPixmap=TQPixmap(320,240,-1, TQPixmap::DefaultOptim);
	if (mPixmap.convertFromImage(mImage,0) == true)
		mImageContainer->updatePixmap(mPixmap);
	connect(&qtimer, TQT_SIGNAL(timeout()), this, TQT_SLOT(slotUpdateImage()) );
	qtimer.start(0,FALSE);
}

TestbedWebcamDialog::~ TestbedWebcamDialog( )
{
	mVideoDevicePool->stopCapturing();
	mVideoDevicePool->close();
}

void TestbedWebcamDialog::slotUpdateImage()
{
	mVideoDevicePool->getFrame();
	mVideoDevicePool->getImage(&mImage);
	mImageContainer->updatePixmap( TQPixmap( mImage ) );
}


#include "testbedwebcamdialog.moc"
