/*  *************************************************************************
    *   copyright: (C) 2003 Richard Lrkng <nouseforaname@home.se>         *
    *   copyright: (C) 2003 Gav Wood <gav@kde.org>                          *
    *************************************************************************
*/

/*  *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef SMSCLIENT_H
#define SMSCLIENT_H

#include "smsservice.h"
#include "kopetemessage.h"

#include <tqobject.h>
#include <tqstringlist.h>

class SMSClientPrefsUI;
class SMSContact;
class TQListViewItem;
class KProcess;

class SMSClient : public SMSService
{
	Q_OBJECT
public:
	SMSClient(Kopete::Account* account);
	~SMSClient();

	void send(const Kopete::Message& msg);
	void setWidgetContainer(TQWidget* parent, TQGridLayout* container);

	int maxSize();
	const TQString& description();

public slots:
	void savePreferences();

private slots:
	void slotReceivedOutput(KProcess*, char  *buffer, int  buflen);
	void slotSendFinished(KProcess* p);
signals:
	void messageSent(const Kopete::Message &);

private:
	TQWidget* configureWidget(TQWidget* parent);

	SMSClientPrefsUI* prefWidget;
	TQStringList providers();
	TQStringList output;

	Kopete::Message m_msg;

	TQString m_description;
} ;

#endif //SMSCLIENT_H
