/*  *************************************************************************
    *   copyright: (C) 2005 Justin Huff <jjhuff@mspin.net>                  *
    *************************************************************************
*/

/*  *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef GSMLIB_H_039562406
#define GSMLIB_H_039562406

#include "config.h"
#ifdef INCLUDE_SMSGSM

#include <unistd.h>

#include <gsmlib/gsm_unix_serial.h>
#include <gsmlib/gsm_sms.h>
#include <gsmlib/gsm_me_ta.h>
#include <gsmlib/gsm_util.h>
#include <gsmlib/gsm_event.h>

#include "smsservice.h"
#include "kopetemessage.h"

#include <tqobject.h>
#include <tqevent.h>
#include <tqthread.h>
#include <tqmutex.h>
#include <tqvaluelist.h>
#include <tqstringlist.h>

class GSMLibPrefsUI;
class SMSContact;
class TQListViewItem;
class KProcess;
class GSMLibThread;

class GSMLib : public SMSService
{
    Q_OBJECT
public:
    GSMLib(Kopete::Account* account);
    ~GSMLib();

    void send(const Kopete::Message& msg);
    void setWidgetContainer(TQWidget* parent, TQGridLayout* container);

    int maxSize();
    const TQString& description();

public slots:
    void savePreferences();
	virtual void connect();
	virtual void disconnect();

//signals:
//	void messageSent(const Kopete::Message &);
protected:
	virtual void customEvent(TQCustomEvent* e);
	
    TQWidget* configureWidget(TQWidget* parent);
	void saveConfig(); 
	void loadConfig(); 

    GSMLibPrefsUI* prefWidget;
    TQStringList output;

	TQString m_device;
	
    TQString m_description;

	GSMLibThread* m_thread;
	
} ;


/// Custom event for async-events
class GSMLibEvent : public QCustomEvent
{
public:
	enum SubType { CONNECTED, DISCONNECTED, NEW_MESSAGE, MSG_SENT, MSG_NOT_SENT };
	
	GSMLibEvent(SubType t);

	SubType subType();
	void setSubType(SubType t);

	TQString Text;
	TQString Number;
	
	TQString Reason;
	
	Kopete::Message Message;
protected:
	SubType m_subType;
};

/// Thread to deal with GsmLib's blocking 
class GSMLibThread : public TQThread, gsmlib::GsmEvent
{
public:
	GSMLibThread(TQString dev, GSMLib* parent);
	virtual ~GSMLibThread();
	
	virtual void run();
	void stop();
	void send(const Kopete::Message& msg);
protected:
	bool doConnect();
	void pollForMessages();
	void sendMessageQueue();
	void sendMessage(const Kopete::Message& msg);
    void SMSReception(gsmlib::SMSMessageRef newMessage, SMSMessageType messageType);
    void SMSReceptionIndication(std::string storeName, unsigned int index, SMSMessageType messageType);
	
	GSMLib* m_parent;
	TQString m_device;
	
    gsmlib::MeTa* m_MeTa;
	
	bool m_run;
	
    struct IncomingMessage
    {
        int Index;
        TQString StoreName;
        gsmlib::SMSMessageRef Message;
        GsmEvent::SMSMessageType Type; 

        IncomingMessage() :   Index(-1)
        {}
    };

    typedef TQValueList<IncomingMessage> MessageList;
    MessageList m_newMessages;

	typedef TQValueList<Kopete::Message> KopeteMessageList;
	KopeteMessageList m_outMessages;
	TQMutex m_outMessagesMutex;
};

#endif
#endif //GSMLIB_H_039562406
