/*
  Kopete Oscar Protocol
  icquserinfotask.h - SNAC 0x15 parsing for user info

  Copyright (c) 2004 Matt Rogers <mattr@kde.org>

  Kopete (c) 2002-2004 by the Kopete developers <kopete-devel@kde.org>

  *************************************************************************
  *                                                                       *
  * This library is free software; you can redistribute it and/or         *
  * modify it under the terms of the GNU Lesser General Public            *
  * License as published by the Free Software Foundation; either          *
  * version 2 of the License, or (at your option) any later version.      *
  *                                                                       *
  *************************************************************************
*/

#ifndef ICQUSERINFOTASK_H
#define ICQUSERINFOTASK_H

#include <tqmap.h>
#include <tqstring.h>

#include "icqtask.h"
#include "icquserinfo.h"

class Transfer;

/**
@author Kopete Developers
*/
class ICQUserInfoRequestTask : public ICQTask
{
Q_OBJECT
public:
	ICQUserInfoRequestTask( Task* parent );
	~ICQUserInfoRequestTask();

	enum { Long = 0, Short };
	
	void setUser( const TQString& user ) { m_userToRequestFor = user; }
	void setType( unsigned int type ) { m_type = type; }
	void setInfoToRequest( unsigned int type );
	
	ICQGeneralUserInfo generalInfoFor( const TQString& contact );
	ICQEmailInfo emailInfoFor( const TQString& contact );
	ICQMoreUserInfo moreInfoFor( const TQString& contact );
	ICQWorkUserInfo workInfoFor( const TQString& contact );
	TQString notesInfoFor( const TQString& contact );
	ICQShortInfo shortInfoFor( const TQString& contact );
	ICQInterestInfo interestInfoFor( const TQString& contact );
	
	virtual bool forMe( const Transfer* transfer ) const;
	virtual bool take( Transfer* transfer );
	virtual void onGo();

signals:
	void receivedInfoFor( const TQString& contact, unsigned int type );
	
private:
	TQMap<int, ICQGeneralUserInfo> m_genInfoMap;
	TQMap<int, ICQEmailInfo> m_emailInfoMap;
	TQMap<int, ICQMoreUserInfo> m_moreInfoMap;
	TQMap<int, ICQWorkUserInfo> m_workInfoMap;
	TQMap<int, ICQShortInfo> m_shortInfoMap;
	TQMap<int, ICQInterestInfo> m_interestInfoMap;
	TQMap<int, TQString> m_notesInfoMap;
	TQMap<int, TQString> m_contactSequenceMap;
	TQMap<TQString, int> m_reverseContactMap;
	unsigned int m_type;
	TQString m_userToRequestFor;

};
#endif

//kate: indent-mode csands; tab-width 4; space-indent off; replace-tabs off;
