/*
 * tasks.h - basic tasks
 * Copyright (C) 2001, 2002  Justin Karneges
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef JABBER_TASKS_H
#define JABBER_TASKS_H

#include<tqstring.h>
#include<tqdom.h>

#include"im.h"
#include"xmpp_vcard.h"

namespace XMPP
{
	class Roster;
	class Status;

	class JT_Register : public Task
	{
		Q_OBJECT
	public:
		JT_Register(Task *parent);
		~JT_Register();

		void reg(const TQString &user, const TQString &pass);
		void changepw(const TQString &pass);
		void unreg(const Jid &j="");

		const Form & form() const;
		void getForm(const Jid &);
		void setForm(const Form &);

		void onGo();
		bool take(const TQDomElement &);

	private:
		TQDomElement iq;
		Jid to;

		class Private;
		Private *d;
	};

	class JT_UnRegister : public Task
	{
		Q_OBJECT
	public:
		JT_UnRegister(Task *parent);
		~JT_UnRegister();

		void unreg(const Jid &);

		void onGo();

	private slots:
		void getFormFinished();
		void unregFinished();

	private:
		class Private;
		Private *d;
	};

	class JT_Roster : public Task
	{
		Q_OBJECT
	public:
		JT_Roster(Task *parent);
		~JT_Roster();

		void get();
		void set(const Jid &, const TQString &name, const TQStringList &groups);
		void remove(const Jid &);

		const Roster & roster() const;

		TQString toString() const;
		bool fromString(const TQString &);

		void onGo();
		bool take(const TQDomElement &x);

	private:
		int type;
		TQDomElement iq;
		Jid to;

		class Private;
		Private *d;
	};

	class JT_PushRoster : public Task
	{
		Q_OBJECT
	public:
		JT_PushRoster(Task *parent);
		~JT_PushRoster();

		bool take(const TQDomElement &);

	signals:
		void roster(const Roster &);

	private:
		class Private;
		Private *d;
	};

	class JT_Presence : public Task
	{
		Q_OBJECT
	public:
		JT_Presence(Task *parent);
		~JT_Presence();

		void pres(const Status &);
		void pres(const Jid &, const Status &);
		void sub(const Jid &, const TQString &subType);

		void onGo();

	private:
		TQDomElement tag;
		int type;

		class Private;
		Private *d;
	};

	class JT_PushPresence : public Task
	{
		Q_OBJECT
	public:
		JT_PushPresence(Task *parent);
		~JT_PushPresence();

		bool take(const TQDomElement &);

	signals:
		void presence(const Jid &, const Status &);
		void subscription(const Jid &, const TQString &);

	private:
		class Private;
		Private *d;
	};

	class JT_Message : public Task
	{
		Q_OBJECT
	public:
		JT_Message(Task *parent, const Message &);
		~JT_Message();

		void onGo();

	private:
		Message m;

		class Private;
		Private *d;
	};

	class JT_PushMessage : public Task
	{
		Q_OBJECT
	public:
		JT_PushMessage(Task *parent);
		~JT_PushMessage();

		bool take(const TQDomElement &);

	signals:
		void message(const Message &);

	private:
		class Private;
		Private *d;
	};

	class JT_GetLastActivity : public Task
	{
		Q_OBJECT
	public:
		JT_GetLastActivity(Task *);
		~JT_GetLastActivity();

		void get(const Jid &);

		int seconds() const;
		const TQString &message() const;

		void onGo();
		bool take(const TQDomElement &x);

	private:
		class Private;
		Private *d;

		TQDomElement iq;
		Jid jid;
	};

	class JT_GetServices : public Task
	{
		Q_OBJECT
	public:
		JT_GetServices(Task *);

		void get(const Jid &);

		const AgentList & agents() const;

		void onGo();
		bool take(const TQDomElement &x);

	private:
		class Private;
		Private *d;

		TQDomElement iq;
		Jid jid;
		AgentList agentList;
	};

	class JT_VCard : public Task
	{
		Q_OBJECT
	public:
		JT_VCard(Task *parent);
		~JT_VCard();

		void get(const Jid &);
		void set(const VCard &);

		const Jid & jid() const;
		const VCard  & vcard() const;
		
		void onGo();
		bool take(const TQDomElement &x);

	private:
		int type;

		class Private;
		Private *d;
	};

	class JT_Search : public Task
	{
		Q_OBJECT
	public:
		JT_Search(Task *parent);
		~JT_Search();

		const Form & form() const;
		const TQValueList<SearchResult> & results() const;

		void get(const Jid &);
		void set(const Form &);

		void onGo();
		bool take(const TQDomElement &x);

	private:
		TQDomElement iq;
		int type;

		class Private;
		Private *d;
	};

	class JT_ClientVersion : public Task
	{
		Q_OBJECT
	public:
		JT_ClientVersion(Task *);

		void get(const Jid &);
		void onGo();
		bool take(const TQDomElement &);

		const Jid & jid() const;
		const TQString & name() const;
		const TQString & version() const;
		const TQString & os() const;

	private:
		TQDomElement iq;

		Jid j;
		TQString v_name, v_ver, v_os;
	};
/*
	class JT_ClientTime : public Task
	{
		Q_OBJECT
	public:
		JT_ClientTime(Task *, const Jid &);

		void go();
		bool take(const TQDomElement &);

		Jid j;
		TQDateTime utc;
		TQString timezone, display;

	private:
		TQDomElement iq;
	};
*/
	class JT_ServInfo : public Task
	{
		Q_OBJECT
	public:
		JT_ServInfo(Task *);
		~JT_ServInfo();

		bool take(const TQDomElement &);
	};

	class JT_Gateway : public Task
	{
		Q_OBJECT
	public:
		JT_Gateway(Task *);

		void get(const Jid &);
		void set(const Jid &, const TQString &prompt);
		void onGo();
		bool take(const TQDomElement &);

		Jid jid() const;
		TQString desc() const;
		TQString prompt() const;

	private:
		TQDomElement iq;

		int type;
		Jid v_jid;
		TQString v_prompt, v_desc;
	};

	class JT_Browse : public Task
	{
		Q_OBJECT
	public:
		JT_Browse(Task *);
		~JT_Browse();

		void get(const Jid &);

		const AgentList & agents() const;
		const AgentItem & root() const;

		void onGo();
		bool take(const TQDomElement &);

	private:
		class Private;
		Private *d;

		AgentItem browseHelper (const TQDomElement &i);
	};

	class JT_DiscoItems : public Task
	{
		Q_OBJECT
	public:
		JT_DiscoItems(Task *);
		~JT_DiscoItems();
	
		void get(const Jid &, const TQString &node = TQString::null);
		void get(const DiscoItem &);
	
		const DiscoList &items() const;
	
		void onGo();
		bool take(const TQDomElement &);
	
	private:
		class Private;
		Private *d;
	};

	class JT_DiscoInfo : public Task
	{
		Q_OBJECT
	public:
		JT_DiscoInfo(Task *);
		~JT_DiscoInfo();
	
		void get(const Jid &, const TQString &node = TQString::null, const DiscoItem::Identity = DiscoItem::Identity());
		void get(const DiscoItem &);
	
		const DiscoItem &item() const;
		const Jid& jid() const;
		const TQString& node() const;
	
		void onGo();
		bool take(const TQDomElement &);
	
	private:
		class Private;
		Private *d;
	};

	class JT_DiscoPublish : public Task
	{
		Q_OBJECT
	public:
		JT_DiscoPublish(Task *);
		~JT_DiscoPublish();
	
		void set(const Jid &, const DiscoList &);
	
		void onGo();
		bool take(const TQDomElement &);
	
	private:
		class Private;
		Private *d;
	};

	class JT_MucPresence : public Task
	{
		Q_OBJECT
	public:
		JT_MucPresence(Task *parent);
		~JT_MucPresence();

		void pres(const Status &);
		void pres(const Jid &, const Status &, const TQString &password);

		void onGo();

	private:
		TQDomElement tag;
		int type;

		class Private;
		Private *d;
	};
	
	class JT_PrivateStorage : public Task
	{
		Q_OBJECT
	public:
		JT_PrivateStorage(Task *parent);
		~JT_PrivateStorage();

		void set(const TQDomElement &);
		void get(const TQString &tag, const TQString& xmlns);
		
		TQDomElement element();

		void onGo();
		bool take(const TQDomElement &);
		
	private:
		class Private;
		Private *d;
	};
	
}

#endif
