/*
 * servsock.cpp - simple wrapper to QServerSocket
 * Copyright (C) 2003  Justin Karneges
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include"servsock.h"

// CS_NAMESPACE_BEGIN

//----------------------------------------------------------------------------
// ServSock
//----------------------------------------------------------------------------
class ServSock::Private
{
public:
	Private() {}

	ServSockSignal *serv;
};

ServSock::ServSock(TQObject *parent)
:TQObject(parent)
{
	d = new Private;
	d->serv = 0;
}

ServSock::~ServSock()
{
	stop();
	delete d;
}

bool ServSock::isActive() const
{
	return (d->serv ? true: false);
}

bool ServSock::listen(Q_UINT16 port)
{
	stop();

	d->serv = new ServSockSignal(port);
	if(!d->serv->ok()) {
		delete d->serv;
		d->serv = 0;
		return false;
	}
	connect(d->serv, TQT_SIGNAL(connectionReady(int)), TQT_SLOT(sss_connectionReady(int)));

	return true;
}

void ServSock::stop()
{
	delete d->serv;
	d->serv = 0;
}

int ServSock::port() const
{
	if(d->serv)
		return d->serv->port();
	else
		return -1;
}

TQHostAddress ServSock::address() const
{
	if(d->serv)
		return d->serv->address();
	else
		return TQHostAddress();
}

void ServSock::sss_connectionReady(int s)
{
	connectionReady(s);
}


//----------------------------------------------------------------------------
// ServSockSignal
//----------------------------------------------------------------------------
ServSockSignal::ServSockSignal(int port)
:TQServerSocket(port, 16)
{
}

void ServSockSignal::newConnection(int x)
{
	connectionReady(x);
}

// CS_NAMESPACE_END

#include "servsock.moc"
