/*
    kirctransferhandler.h - DCC Handler

    Copyright (c) 2003-2004 by Michel Hermier <michel.hermier@wanadoo.fr>

    Kopete    (c) 2003-2004 by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef KIRCTRANSFERHANDLER_H
#define KIRCTRANSFERHANDLER_H

#include <tqhostaddress.h>

#include "kirctransfer.h"
#include "kirctransferserver.h"

class TQFile;
class TQTextCodec;

class KExtendedSocket;

namespace KIRC
{

class TransferHandler
	: public QObject
{
	Q_OBJECT

public:
	static TransferHandler *self();

	TransferServer *server();
	TransferServer *server( Q_UINT16 port, int backlog  = 1 );

	TransferServer *createServer(KIRC::Engine *engine, TQString m_userName,
			Transfer::Type type,
			TQString fileName, Q_UINT32 fileSize);

	Transfer *createClient(
		KIRC::Engine *engine, TQString nick,// TQString nick_peer_adress,
		TQHostAddress peer_address, Q_UINT16 peer_port,
		Transfer::Type type,
		TQString file = TQString::null, Q_UINT32 fileSize = 0 );

//	void registerServer( DCCServer * );
//	TQPtrList<DCCServer> getRegisteredServers();
//	static TQPtrList<DCCServer> getAllRegisteredServers();
//	void unregisterServer( DCCServer * );

//	void registerClient( DCCClient * );
//	TQPtrList<DCCClient> getRegisteredClients();
//	static TQPtrList<DCCClient> getAllRegisteredClients();
//	void unregisterClient( DCCClient * );

signals:
	void transferServerCreated(KIRC::TransferServer *server);
	void transferCreated(KIRC::Transfer *transfer);

private:
//	TransferHandler();

	TransferServer *m_server;
//	TQPtrList<TransferServer> m_servers;
//	TQPtrList<Transfer> m_clients;
};

}

#endif
