/*
    Kopete Groupwise Protocol
    privacymanager.cpp - stores the user's privacy information and maintains it on the server

    Copyright (c) 2004      SUSE Linux AG	 	 http://www.suse.com
    
    Kopete (c) 2002-2004 by the Kopete developers <kopete-devel@kde.org>
 
    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU Lesser General Public            *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#ifndef PRIVACYMANAGER_H
#define PRIVACYMANAGER_H

#include <tqobject.h>
#include <tqstringlist.h>

class Client;

/**
Keeps a record of the server side privacy allow and deny lists, default policy and whether the user is allowed to change privacy settings

@author SUSE AG
*/
class PrivacyManager : public QObject
{
Q_OBJECT
public:
	PrivacyManager( Client * client, const char *name = 0);
	~PrivacyManager();
	// accessors
	bool isBlocked( const TQString & dn );
	TQStringList allowList();
	TQStringList denyList();
	bool isPrivacyLocked();
	bool defaultDeny();
	bool defaultAllow();
	// mutators
	void setDefaultAllow( bool allow );
	void setDefaultDeny( bool deny );
	void setAllow( const TQString & dn );
	void setDeny( const TQString & dn );
	void getDetailsForPrivacyLists();
	// change everything at once
	void setPrivacy( bool defaultIsDeny, const TQStringList & allowList, const TQStringList & denyList );

signals:
	void privacyChanged( const TQString &dn, bool allowed );
public slots:
	/** 
	 * Used to initialise the privacy manager using the server side privacy list
	 */
	void slotGotPrivacySettings( bool locked, bool defaultDeny, const TQStringList & allowList, const TQStringList & denyList );
protected:
	void addAllow( const TQString & dn );
	void addDeny( const TQString & dn );
	void removeAllow( const TQString & dn );
	void removeDeny( const TQString & dn );
	/**
	 * A set difference function
	 * @param lhs The set of strings to be subtracted from
	 * @param rhs The set of string to subtract
	 * @return The difference between the two sets
	 */
	TQStringList difference( const TQStringList & lhs, const TQStringList & rhs );
protected slots:
	// Receive the results of Tasks manipulating the privacy lists
	void slotDefaultPolicyChanged();
	void slotAllowAdded();
	void slotDenyAdded();
	void slotAllowRemoved();
	void slotDenyRemoved();	
private:
	Client * m_client;
	bool m_locked;
	bool m_defaultDeny;
	TQStringList m_allowList;
	TQStringList m_denyList;
};

#endif
