/*
    eventtransfer.h - Kopete Groupwise Protocol
    
    Copyright (c) 2004      SUSE Linux AG	 	 http://www.suse.com
    
    Kopete (c) 2002-2004 by the Kopete developers <kopete-devel@kde.org>
 
    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU Lesser General Public            *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#ifndef GW_EVENTTRANSFER_H
#define GW_EVENTTRANSFER_H

#include <tqcstring.h>
#include <tqdatetime.h>

#include "gwerror.h" 

#include "transfer.h"

namespace Event {
	
}

/**
 * Transfer representing an event, a message generated by the server in response to external stimulus
 * This class can contain varying data items depending on the type of event.  
 * You can query which data is present before trying to access it
 * @author Kopete Developers
 */
class EventTransfer : public Transfer
{
public:
	/** 
	 * Flags describing the possible contents of an event transfer
	 */
	enum Contents { EventType = 	0x00000001, 
					Source = 		0x00000002, 
					TimeStamp = 	0x00000004, 
					Guid = 			0x00000008,
					Flags = 		0x00000010,
					Message = 		0x00000020,
					Status = 		0x00000040,
					StatusText = 	0x00000080 };
	/**
	 * Constructor
	 * @param eventType the event code describing the event, see @refGroupWise::Event.
	 * @param source the user generating the event.
	 * @param timeStamp the time at which the event was received.
	 */
	EventTransfer( const Q_UINT32 eventType, const TQString & source, TQDateTime timeStamp );
	~EventTransfer();
	/** 
	 * Access the bitmask that describes the transfer's contents.  Use @ref Contents to determine what it contains
	 */
	Q_UINT32 contents();
	/**
	 * Convenience accessors to see what the transfer contains
	 */
	bool hasEventType();
	bool hasSource();
	bool hasTimeStamp();
	bool hasGuid();
	bool hasFlags();
	bool hasMessage();
	bool hasStatus();
	bool hasStatusText();
	
	/**
	 * Accessors for the transfer's contents
	 */
	TransferType type() { return Transfer::EventTransfer; }
	int eventType();
	TQString source();
	TQDateTime timeStamp();
	GroupWise::ConferenceGuid guid();
	Q_UINT32 flags();
	TQString message();
	Q_UINT16 status();
	TQString statusText();
	
	/**
	 * Mutators to set the transfer's contents
	 */
	void setGuid( const GroupWise::ConferenceGuid & guid );
	void setFlags( const Q_UINT32 flags );
	void setMessage( const TQString & message );
	void setStatus( const Q_UINT16 status );
	void setStatusText( const TQString & statusText);
	
private:
	Q_UINT32 m_contentFlags;
	int m_eventType;
	TQString m_source;
	TQDateTime m_timeStamp;
	GroupWise::ConferenceGuid m_guid;
	Q_UINT32 m_flags;
	TQString m_message;
	Q_UINT16 m_status;
	TQString m_statusText;
};

#endif
