/*
    statisticsdialog.h - Kopete History Dialog

    Copyright (c) 2003-2004 by Marc Cramdal        <marc.cramdal@gmail.com>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef _STATISTICSDIALOG_H
#define _STATISTICSDIALOG_H

#include <tqwidget.h>
#include <kdialogbase.h>
#include "kopetemetacontact.h"

class TQCanvasView;
class TQCanvas;
class TQStringList;

class StatisticsWidget;
class StatisticsPlugin;
class StatisticsDB;
class StatisticsContact;

class KHTMLPart;
class KURL;
namespace KParts
{
	class URLArgs;
}

class StatisticsDialog : public KDialogBase
{
	Q_OBJECT
	public:
		StatisticsDialog(StatisticsContact *contact, StatisticsDB* db, TQWidget* parent=0,
			const char* name="StatisticsDialog");
	private:
		TQString generateHTMLChart(const int *hours, const int *hours2, const int *hours3, const TQString & caption, const TQString & color);
		TQString generateHTMLChartBar(int height, const TQString & color, const TQString & caption);
		TQString stringFromSeconds(const int seconds);
		
		StatisticsWidget *mainWidget;
		KHTMLPart *generalHTMLPart;
		
		/// Database from which we get the statistics
		StatisticsDB *m_db;
		/// Metacontact for which we get the statistics from m_db
		StatisticsContact *m_contact;
		
		void generatePageFromQStringList(TQStringList values, const TQString & subTitle);
		
		/// Generates the main page
		void generatePageGeneral();
		/**
		 * @brief Generates the page for a given day of the week.
		 * \param dayOfWeek Monday..Sunday, 0..7
		 */
		void generatePageForDay(const int dayOfWeek);
		void generatePageForMonth(const int monthOfYear);
		

private slots:
		/**
		 * We manage the openURLRequestDelayed signal from the generalHTMLPart->browserExtension() in order to
		 * generate requested pages on the flow.
		 */
		void slotOpenURLRequest(const KURL& url, const KParts::URLArgs&);
		void slotAskButtonClicked();

};


#endif // _STATISTICSDIALOG_H
