/***************************************************************************
                          cryptographyplugin.h  -  description
                             -------------------
    begin                : jeu nov 14 2002
    copyright            : (C) 2002-2004 by Olivier Goffart
    email                : ogoffart @ kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CryptographyPLUGIN_H
#define CryptographyPLUGIN_H


#include "kopeteplugin.h"

class TQStringList;
class TQString;
class TQTimer;

namespace Kopete
{
	class Message;
	class MetaContact;
	class ChatSession;
	class SimpleMessageHandlerFactory;
}

/**
  * @author Olivier Goffart
  */

class CryptographyPlugin : public Kopete::Plugin
{
	Q_OBJECT

public:
	enum CacheMode
	{
		Keep	= 0,
		Time	= 1,
		Never	= 2
	};

	static CryptographyPlugin  *plugin();
	static TQCString cachedPass();
	static void setCachedPass(const TQCString &pass);
	static bool passphraseHandling();
	static const TQRegExp isHTML;

	CryptographyPlugin( TQObject *parent, const char *name, const TQStringList &args );
	~CryptographyPlugin();

public slots:

	void slotIncomingMessage( Kopete::Message& msg );
	void slotOutgoingMessage( Kopete::Message& msg );

private slots:

	void slotSelectContactKey();
	void slotForgetCachedPass();
	void loadSettings();
	
	void slotNewKMM(Kopete::ChatSession *);

private:
	static CryptographyPlugin* pluginStatic_;
	Kopete::SimpleMessageHandlerFactory *m_inboundHandler;
	TQCString m_cachedPass;
	TQTimer *m_cachedPass_timer;

	//cache messages for showing
	TQMap<TQString, TQString> m_cachedMessages;

	//Settings
	TQString mPrivateKeyID;
	int mCacheMode;
	unsigned int mCacheTime;
	bool mAlsoMyKey;
	bool mAskPassPhrase;
	bool mCachePassPhrase;
};

#endif

/*
 * Local variables:
 * c-indentation-style: k&r
 * c-basic-offset: 8
 * indent-tabs-mode: t
 * End:
 */
// vim: set noet ts=4 sts=4 sw=4:

