/*
    kimifaceimpl.cpp - Kopete DCOP Interface

    Copyright (c) 2004 by Will Stephenson     <lists@stevello.free-online.co.uk>

    Kopete    (c) 2002-2004      by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#ifndef KIMIFACEIMPL_H
#define KIMIFACEIMPL_H

#include <tqobject.h>
#include "kimiface.h"

namespace Kopete
{
class MetaContact;
}

class KIMIfaceImpl : public TQObject, public KIMIface
{
	Q_OBJECT
public:
	KIMIfaceImpl();
	~KIMIfaceImpl();

	TQStringList allContacts();
	TQStringList reachableContacts();
	TQStringList onlineContacts();
	TQStringList fileTransferContacts();
	
// individual
	bool isPresent( const TQString &uid );
	TQString displayName( const TQString &uid );
	TQString presenceString( const TQString &uid );
	int presenceStatus( const TQString &uid );
	bool canReceiveFiles( const TQString &uid );
	bool canRespond( const TQString &uid );
	TQString locate( const TQString &contactId, const TQString &protocol );
// metadata
	TQPixmap icon( const TQString &uid );
	TQString context( const TQString &uid );
// App capabilities
	TQStringList protocols();
	
// ACTORS
	/**
	 * Message a contact by their metaContactId, aka their uid in KABC.
	 */
	void messageContact( const TQString &uid, const TQString& message );
	
	/**
	 * Open a chat to a contact, and optionally set some initial text
	 */
	void messageNewContact(  const TQString &contactId, const TQString &protocolId );

	/**
	 * Message a contact by their metaContactId, aka their uid in KABC.
	 */
	void chatWithContact( const TQString &uid );

	/**
	 * Send the file to the contact
	 */
	void sendFile(const TQString &uid, const KURL &sourceURL,
		const TQString &altFileName = TQString::null, uint fileSize = 0);

// MUTATORS
// Contact list
	bool addContact( const TQString &contactId, const TQString &protocolId );
// SIGNALS
	/**
	 * DCOP Signal used to notify 
	 * external apps of status changes.
	 */
	void contactStatusChanged( const TQString &uid);

protected:
	void unknown( const TQString &uid );
protected slots:
	void slotMetaContactAdded( Kopete::MetaContact *mc );
	void slotContactStatusChanged( Kopete::MetaContact *mc );	
	
private:
	Kopete::MetaContact *locateProtocolContact( const TQString & contactId, const TQString & protocolId );
};

#endif



/*
 * Local variables:
 * c-indentation-style: k&r
 * c-basic-offset: 8
 * indent-tabs-mode: t
 * End:
 */
// vim: set noet ts=4 sts=4 sw=4:

