/*
 * newsscroller.h
 *
 * Copyright (c) 2000, 2001 Frerich Raabe <raabe@kde.org>
 * Copyright (c) 2001 Malte Starostik <malte@kde.org>
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. For licensing and distribution details, check the
 * accompanying file 'COPYING'.
 */
#ifndef NEWSSCROLLER_H
#define NEWSSCROLLER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "configaccess.h"
#include "newsengine.h"

#include <tqframe.h>
#include <tqptrlist.h>
#include <tqpixmap.h>

class TQTimer;
class Headline;
template <class> class TQPtrList;
typedef TQPtrList<Headline> HeadlineList;

class NewsScroller : public QFrame
{
	Q_OBJECT

	public:
		NewsScroller(TQWidget *, ConfigAccess *, const char * = 0);

		virtual TQSize sizeHint() const;
		virtual TQSizePolicy sizePolicy() const;
	
		// Convenience stuff. Somehow ugly, no?	
		inline bool horizontal() const
		{
			return m_cfg->horizontal(static_cast<ConfigAccess::Direction>(m_cfg->scrollingDirection()));
		}

		inline bool vertical() const
		{
			return m_cfg->vertical(static_cast<ConfigAccess::Direction>(m_cfg->scrollingDirection()));
		}

		inline bool rotated() const
		{
			return m_cfg->rotated(static_cast<ConfigAccess::Direction>(m_cfg->scrollingDirection()));
		}

	public slots:
		void clear();
		void addHeadline(Article::Ptr);
		void reset(bool bSeparatorOnly = false);

	signals:
		void contextMenu();

	protected:
		virtual void enterEvent(TQEvent *);
		virtual void mousePressEvent(TQMouseEvent *);
		virtual void mouseReleaseEvent(TQMouseEvent *);
		virtual void mouseMoveEvent(TQMouseEvent *);
		virtual void wheelEvent(TQWheelEvent *);
		virtual void leaveEvent(TQEvent *);
		virtual void drawContents(TQPainter *);
		virtual void dragEnterEvent( TQDragEnterEvent *);
		virtual void dropEvent(TQDropEvent *);

	protected slots:
		void scroll(int = 1, bool = true);
		void slotTimeout();

	private:
		int scrollWidth() const;
		int scrollHeight() const;
		bool updateActive(const TQPoint &);
		bool isHeadline(const TQString &) const;
		int speedAsInterval( int speed );

	private:
		friend class Headline;
		ConfigAccess *m_cfg;
		TQTimer       *m_scrollTimer;
		mutable HeadlineList m_headlines;
		Headline     *m_activeHeadline;
		TQPixmap      m_separator;
		int          m_offset;
		TQPoint       m_dragPos;
		bool         m_mouseDrag;
		TQString      m_tempHeadline;
		float        m_totalStepping;
		float        m_stepping;
};

#endif // NEWSSCROLLER_H
