/***************************************************************************
*                                slaveevent.h
*                             -------------------
*
*    Revision     : $Id: slaveevent.h 1157648 2010-07-31 19:48:06Z tpearson $
*    begin        : Tue Jan 29 2002
*    copyright    : (C) 2002 by Patrick Charbonnier
*    email        :pch@freeshell.org
*
****************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 ***************************************************************************/


#ifndef SLAVEEVENT_H
#define SLAVEEVENT_H

#include <tqevent.h>

class Transfer;

/**
  *@author Patrick Charbonnier
  */

class SlaveEvent:public QCustomEvent
{
public:
    SlaveEvent(Transfer * _item, unsigned int _event, Q_ULLONG _ldata = 0L);
    SlaveEvent(Transfer * _item, unsigned int _event, const TQString & _msg);
    ~SlaveEvent();

    unsigned int getEvent() const;
    Transfer *getItem() const;
    Q_ULLONG getData() const;
    const TQString & getMsg() const;


private:
    unsigned int m_event;
    Transfer *m_item;
    Q_ULLONG m_ldata;
    TQString m_msg;

};

#endif
