/****************************************************************************
** $Id: kget_iface.h 1157648 2010-07-31 19:48:06Z tpearson $
**
** Copyright (C) 2002 Carsten Pfeiffer <pfeiffer@kde.org>
**
****************************************************************************/

#ifndef KGET_IFACE_H
#define KGET_IFACE_H

#include <dcopobject.h>
#include <kurl.h>

class KGetIface : public DCOPObject
{
    K_DCOP

protected:
    KGetIface( TQCString objId ) : DCOPObject( objId ) {}

k_dcop:
    /**
     * @param src The urls to download
     * @param destDir The destination direction or TQString::null if unspecified
     */
    virtual ASYNC addTransfers( const KURL::List& src, const TQString& destDir = TQString::null ) = 0;
    
    virtual bool isDropTargetVisible() const = 0;
    
    virtual void setDropTargetVisible( bool setVisible ) = 0;

	virtual void setOfflineMode( bool offline ) = 0;

	virtual bool isOfflineMode() const = 0;
};

#endif // KGET_IFACE_H
