/***************************************************************************
*                                  docking.h
*                             -------------------
*
*    Revision     : $Id: docking.h 1157648 2010-07-31 19:48:06Z tpearson $
*    begin        : Tue Jan 29 2002
*    copyright    : (C) 2002 by Patrick Charbonnier
*                 : Based On Caitoo v.0.7.3 (c) 1998 - 2000, Matej Koss
*    email        : pch@freeshell.org
*
****************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 ***************************************************************************/



#ifndef _DOCKING_H_
#define _DOCKING_H_

#include <stdio.h>

#include <tqdragobject.h>

#include <ksystemtray.h>

class KPopupMenu;
class KMainWidget;

class DynamicTip : public QToolTip
{
   public:
       DynamicTip( TQWidget * parent );
       virtual ~DynamicTip() {}//TODO workaround for qt-bug, can be removed after 4.0 
       void setStatus( const TQString & _status );

   protected:
       void maybeTip( const TQPoint & );
       
   private:
       TQString status;
};

class DockWidget:public KSystemTray
{

Q_OBJECT public:
    DockWidget(KMainWidget * parent);
    ~DockWidget();
    /** No descriptions */
    void updateToolTip( const TQString& );
    void changeIcon( const TQString& );



private slots:
    void mousePressEvent(TQMouseEvent * e);

protected:
    // drag and drop
    void dragEnterEvent(TQDragEnterEvent *);
    void dropEvent(TQDropEvent *);

private:
    KMainWidget *parent;
    DynamicTip * dtip;

};

#endif
