/* -------------------------------------------------------------

   toplevel.h (part of The KDE Dictionary Client)

   Copyright (C) 2000-2001 Christian Gebauer <gebauer@kde.org>
   (C) by Matthias Hlzer 1998

   This file is distributed under the Artistic License.
   See LICENSE for details.

   -------------------------------------------------------------

   TopLevel   The toplevel widget of Kdict.

 ------------------------------------------------------------- */

#ifndef _TOPLEVEL_H_
#define _TOPLEVEL_H_

#include <tqtimer.h>
#include <kmainwindow.h>
#include "dcopinterface.h"

class TQSplitter;

class KToggleAction;
class KToolBarPopupAction;

class DictLabelAction;
class DictComboAction;
class DictButtonAction;
class MatchView;
class QueryView;
class OptionsDialog;
class DbSetsDialog;


class TopLevel : public KMainWindow, virtual public KDictIface
{
  Q_OBJECT

  friend class QueryView;

public:

  TopLevel(TQWidget* parent = 0, const char* name = 0);
  ~TopLevel();

  void normalStartup();             // called when started without commandline parameters

  // DCOP-Interface...
  void quit();
  void makeActiveWindow();
  void definePhrase(TQString phrase);
  void matchPhrase(TQString phrase);
  void defineClipboardContent();
  void matchClipboardContent();
  TQStringList getDatabases();
  TQString currentDatabase();
  TQStringList getStrategies();
  TQString currentStrategy();
  bool setDatabase(TQString db);
  bool setStrategy(TQString strategy);
  bool historyGoBack();
  bool historyGoForward();

public slots:

  void define(const TQString &query);
  void defineClipboard();

  void match(const TQString &query);
  void matchClipboard();

protected:
	bool queryClose();

private:

  void setupActions();
  void setupStatusBar();
  void recreateGUI();
  void raiseWindow();

  void addCurrentInputToHistory();  // add text in the query-combobox to the history

private slots:
  void clearInput();                // erase text in query-combobox

  void doDefine();                  // define text in the combobox
  void doMatch();                   // match text in the combobox

  void stopClients();

  void buildHistMenu();
  void queryHistMenu();             // process a query via the history menu
  void clearQueryHistory();

  void stratDbChanged();
  void dbInfoMenuClicked();
  void databaseSelected(int num);

  void enableCopy(bool selected);
  void enablePrintSave();

  void clientStarted(const TQString &message);
  void clientStopped(const TQString &message);
  void resetStatusbar();
  void renderingStarted();
  void renderingStopped();

  void newCaption(const TQString&);

  void toggleMatchListShow();
  void saveMatchViewSize();
  void adjustMatchViewSize();

  void slotConfToolbar();
  void slotNewToolbarConfig();

  void showSetsDialog();
  void hideSetsDialog();
  void setsChanged();

  void showOptionsDialog();
  void hideOptionsDialog();
  void optionsChanged();

private:

  KAction *actSave, *actPrint, *actStartQuery, *actStopQuery, *actCopy;
  KToggleAction *actShowMatchList;
  DictLabelAction *actQueryLabel, *actDbLabel;
  DictComboAction *actQueryCombo, *actDbCombo;
  DictButtonAction *actDefineBtn, *actMatchBtn;
  TQPtrList<KAction> historyActionList, dbActionList;
  KToolBarPopupAction *actBack, *actForward;

  TQSplitter *splitter;              // widgets....
  QueryView *queryView;
  MatchView *matchView;
  OptionsDialog *optDlg;
  DbSetsDialog *setsDlg;

  TQTimer resetStatusbarTimer;
  int stopRef;                      // remember how many "clients" are running
};

#endif
