/***************************************************************************

                    base class for query dialogs

    -----------------------------------------------------------------------

    begin          : Wed Feb 16 20:50:53 MET 2000

    copyright      : (C) 1999-2001 Ewald Arnold <kvoctrain@ewald-arnold.de>
                     (C) 2001 The KDE-EDU team
                     (C) 2005 Peter Hedlund <peter.hedlund@kdemail.net>

    -----------------------------------------------------------------------

 ***************************************************************************

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "QueryDlgBase.h"

#include <tqlineedit.h>
#include <tqmultilineedit.h>
#include <tqradiobutton.h>

#include <LineList.h>

#include <klocale.h>

QueryDlgBase::QueryDlgBase(const TQString & caption, TQWidget *parent, const char *name, bool modal)
  : KDialogBase(Swallow, caption, User1|User2, NoDefault, parent, name, modal, false,
    KGuiItem(i18n("&Stop Query")), KGuiItem(i18n("&Edit Expression...")))
{
  kv_doc = 0;
  kv_exp = 0;
  //type_timeout = kvq_notimeout;
}


QueryDlgBase::~QueryDlgBase ()
{
}


void QueryDlgBase::initFocus() const
{
  //
}


bool QueryDlgBase::smartCompare (const TQString& s1, const TQString &s2,
                                 int ) const
{
  return s1.stripWhiteSpace() == s2.stripWhiteSpace();
}


bool QueryDlgBase::verifyField(TQLineEdit *field, const TQString &really)
{
  if (!field->isEnabled() )
    return true;

  TQColorGroup u_normal = field->colorGroup();
  u_normal.setColor(TQColorGroup::Text, TQColor(0xff, 0x00, 0x00));
  TQColorGroup k_normal = field->colorGroup();
  k_normal.setColor(TQColorGroup::Text, TQColor(0x00, 0x80, 0x00));

  TQPalette known_pal( field->palette());
  TQPalette unknown_pal( field->palette());

  TQFont ft = field->font();
  if (ft.weight() != TQFont::Bold) {
    ft.setWeight(TQFont::Bold);
    field->setFont(ft);
  }

  bool ret = false;
  if (smartCompare(really, field->text(), 0) ) {
    ret = true;
    if ( known_pal.inactive() != k_normal
        || known_pal.active() != k_normal) {
      // replace text colors
      known_pal.setActive(k_normal);
      known_pal.setInactive(k_normal);
      field->setPalette( known_pal );
    }
  }
  else
    if ( unknown_pal.inactive() != u_normal
        || unknown_pal.active() != u_normal) {
      // replace text colors
      unknown_pal.setActive(u_normal);
      unknown_pal.setInactive(u_normal);
      field->setPalette( unknown_pal );
    }
  return ret;
}


void QueryDlgBase::resetField(TQLineEdit *field)
{
  if (!field->isEnabled() )
    return;
  TQColorGroup normal = field->colorGroup();
  normal.setColor(TQColorGroup::Text, TQColor(0x00, 0x00, 0x00));

  TQPalette pal( field->palette());
  // replace text colors

  if ( pal.inactive() != normal
      || pal.active() != normal) {
    pal.setActive(normal);
    pal.setInactive(normal);
    field->setPalette( pal );
  }

  TQFont ft = field->font();
  if (ft.weight() != TQFont::Normal) {
    ft.setWeight(TQFont::Normal);
    field->setFont(ft);
  }
}


bool QueryDlgBase::verifyField(TQMultiLineEdit *field, const TQString &really, bool mixed)
{
  if (!field->isEnabled())
    return true;
  TQColorGroup u_normal = field->colorGroup();
  u_normal.setColor(TQColorGroup::Text, TQColor(0xff, 0x00, 0x00));
  TQColorGroup k_normal = field->colorGroup();
  k_normal.setColor(TQColorGroup::Text, TQColor(0x00, 0x80, 0x00));

  TQPalette known_pal( field->palette());
  TQPalette unknown_pal( field->palette());

  TQFont ft = field->font();
  if (ft.weight() != TQFont::Bold) {
    ft.setWeight(TQFont::Bold);
    field->setFont(ft);
  }

  bool ret = false;
  bool equal = false;
  LineList answerlist (really);
  LineList inputlist (field->text());
  if (!mixed) // no tolerance
    equal = smartCompare(answerlist.allLines(), inputlist.allLines(), 0);
  else {
     bool all = true;
     for (int ai = 0; ai < (int) answerlist.count(); ai++) {
       bool found = false;
       for (int ii = 0; ii < (int) inputlist.count(); ii++) {
         if (answerlist.getLine (ai) == inputlist.getLine(ii) ) {
           found = true;
           break;
         }
       }
       if (!found)
         all = false;
     }
     if (all)
       equal = true;
  }

  if (equal) {
    ret = true;
    if (known_pal.inactive() != k_normal
        || known_pal.active() != k_normal) {
      // replace text colors
      known_pal.setActive(k_normal);
      known_pal.setInactive(k_normal);
      field->setPalette( known_pal );
    }
  }
  else
    if ( unknown_pal.inactive() != u_normal
        || unknown_pal.active() != u_normal) {
      // replace text colors
      unknown_pal.setActive(u_normal);
      unknown_pal.setInactive(u_normal);
      field->setPalette( unknown_pal );
    }
  return ret;
}


void QueryDlgBase::resetField(TQMultiLineEdit *field)
{
  if (!field->isEnabled() )
    return;
  TQColorGroup normal = field->colorGroup();
  normal.setColor(TQColorGroup::Text, TQColor(0x00, 0x00, 0x00));

  TQPalette pal( field->palette());
  // replace text colors

  if ( pal.inactive() != normal
      || pal.active() != normal) {
    pal.setActive(normal);
    pal.setInactive(normal);
    field->setPalette( pal );
  }

  TQFont ft = field->font();
  if (ft.weight() != TQFont::Normal) {
    ft.setWeight(TQFont::Normal);
    field->setFont(ft);
  }
}


void QueryDlgBase::verifyButton(TQRadioButton *radio, bool is_ok, TQWidget *widget2)
{
  if (!radio->isEnabled() )
    return;

  TQColorGroup u_normal = radio->colorGroup();
  u_normal.setColor(TQColorGroup::Foreground, TQColor(0xff, 0x00, 0x00));
  TQColorGroup k_normal = radio->colorGroup();
  k_normal.setColor(TQColorGroup::Foreground, TQColor(0x00, 0x80, 0x00));

  TQPalette known_pal( radio->palette());
  TQPalette unknown_pal( radio->palette());

  // replace text colors

  TQFont ft = radio->font();
  if (ft.weight() != TQFont::Bold) {
    ft.setWeight(TQFont::Bold);
    radio->setFont(ft);
  }

  if (widget2 != 0) {
    ft = widget2->font();
    if (ft.weight() != TQFont::Bold) {
      ft.setWeight(TQFont::Bold);
      widget2->setFont(ft);
    }
  }

  if (is_ok) {
    if ( known_pal.inactive() != k_normal
        || known_pal.active() != k_normal) {
      known_pal.setActive(k_normal);
      known_pal.setInactive(k_normal);
      radio->setPalette( known_pal );
      if (widget2 != 0)
        widget2->setPalette( known_pal );
    }
  }
  else {
    if ( unknown_pal.inactive() != u_normal
        || unknown_pal.active() != u_normal) {
      unknown_pal.setActive(u_normal);
      unknown_pal.setInactive(u_normal);
      radio->setPalette( unknown_pal );
      if (widget2 != 0)
        widget2->setPalette( unknown_pal );
    }
  }
}



void QueryDlgBase::resetButton(TQRadioButton *radio, TQWidget *widget2)
{
  if (!radio->isEnabled() )
    return;
  TQColorGroup normal = radio->colorGroup();
  normal.setColor(TQColorGroup::Foreground, TQColor(0x00, 0x00, 0x00));

  TQPalette pal(radio->palette());
  // replace text colors, avoid flickering
  if ( pal.inactive() != normal
      || pal.active() != normal) {
    pal.setActive(normal);
    pal.setInactive(normal);
    radio->setPalette( pal );
    if (widget2 != 0)
      widget2->setPalette( pal );
  }

  TQFont ft = radio->font();
  if (ft.weight() != TQFont::Normal) {
    ft.setWeight(TQFont::Normal);
    radio->setFont(ft);
  }

  if (widget2 != 0) {
    ft = widget2->font();
    if (ft.weight() != TQFont::Normal) {
      ft.setWeight(TQFont::Normal);
      widget2->setFont(ft);
    }
  }
}


TQString  QueryDlgBase::getOKComment(int percent_done)
{
  return i18n("Well done, you knew the correct answer. %1% done.").arg(percent_done);
}


TQString  QueryDlgBase::getTimeoutComment(int percent_done)
{
  return i18n("You waited too long to enter the correct answer. %1% done.").arg(percent_done);
}


TQString  QueryDlgBase::getNOKComment(int percent_done)
{
  return i18n("Your answer was wrong. %1% done.").arg(percent_done);
}

void QueryDlgBase::closeEvent(TQCloseEvent * /*e*/)
{
  emit sigQueryChoice(StopIt);
}

void QueryDlgBase::slotUser1()
{
  emit sigQueryChoice(StopIt);
}


#include "QueryDlgBase.moc"
