/***************************************************************************

                   entry dialog for table cell contents

    -----------------------------------------------------------------------

    begin          : Thu Mar 11 20:50:53 MET 1999

    copyright      : (C) 1999-2001 Ewald Arnold <kvoctrain@ewald-arnold.de>
                     (C) 2001 The KDE-EDU team
                     (C) 2005 Peter Hedlund <peter.hedlund@kdemail.net>

    -----------------------------------------------------------------------

 ***************************************************************************

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef EntryDlg_included
#define EntryDlg_included

#include <tqtable.h>

#include <kdialogbase.h>

#include "FromToEntryPage.h"
#include "CommonEntryPage.h"
#include "AuxInfoEntryPage.h"
#include "TenseEntryPage.h"
#include "AdjEntryPage.h"
#include "MCEntryPage.h"

class LangSet;
class TQTabWidget;
class KMainWindow;
class kvoctrainDoc;

class EntryDlg : public KDialogBase
{
  Q_OBJECT

public:

  enum EditResult {EditCancel, EditApply, EditUndo, EditPageUp, EditPageDown, EditUp, EditDown, EditLeft, EditRight};

  enum EnableType {EnableAll, EnableOnlyCommon, EnableNone, EnableOnlyOriginal };

  EntryDlg
  ( KMainWindow   *main,
    kvoctrainDoc  *doc,
    bool           multi_sel,
    bool           origin,
    grade_t        f_grd,
    grade_t        t_grd,
    count_t        f_qcount,
    count_t        t_qcount,
    count_t        f_bcount,
    count_t        t_bcount,
    time_t         f_qdate,
    time_t         t_qdate,
    TQString        f_faux_ami,
    TQString        t_faux_ami,
    TQString        _expr,
    int            _lesson,
    TQComboBox     *_lessonBox,
    TQString        lang,
    LangSet       &langset,
    TQString        remark,
    TQString        _type,
    TQString        pronunce,
    TQString        synonym,
    TQString        antonym,
    TQString        example,
    TQString        usagelabel,
    TQString        paraphrase,
    const          Conjugation &con_prefix,
    const          Conjugation &conjugations,
    const          Article &article,
    const          Comparison &comp,
    const          MultipleChoice &mc,
    QueryManager  &querymanager,
    const TQString &title,
    bool           active,
    const TQFont&   ipafont,
    TQWidget       *parent = 0,
    const char    *name = 0,
    bool           modal = false
  );

  ~EntryDlg ();

  void setData
    (kvoctrainDoc  *doc,
    bool           multi_sel,
    bool           origin,
    grade_t        f_grd,
    grade_t        t_grd,
    count_t        f_qcount,
    count_t        t_qcount,
    count_t        f_bcount,
    count_t        t_bcount,
    time_t         f_qdate,
    time_t         t_qdate,
    TQString        f_faux_ami,
    TQString        t_faux_ami,
    TQString        _expr,
    int            _lesson,
    TQComboBox     *_lessonBox,
    TQString        lang,
    LangSet       &langset,
    TQString        remark,
    TQString        _type,
    TQString        pronunce,
    TQString        synonym,
    TQString        antonym,
    TQString        example,
    TQString        usagelabel,
    TQString        paraphrase,
    const          Conjugation &con_prefix,
    const          Conjugation &conjugations,
    const          Article &article,
    const          Comparison &comp,
    const          MultipleChoice &mc,
    QueryManager  &querymanager,
    const TQString &title,
    bool           active);

  bool  fromDateDirty   () const { return from_page ? from_page->dateDirty() : false; }
  bool  fromGradeDirty  () const { return from_page ? from_page->gradeDirty() : false; }
  bool  fromBCountDirty () const { return from_page ? from_page->bCountDirty() : false; }
  bool  fromQCountDirty () const { return from_page ? from_page->qCountDirty() : false; }
  TQString getFromFauxAmi  () const { return from_page ? from_page->getFauxAmi() : TQString(""); }

  time_t  getFromDate   () const { return from_page ? from_page->getDate() : 0; }
  grade_t getFromGrade  () const { return from_page ? from_page->getGrade() : KV_NORM_GRADE; }
  count_t getFromBCount () const { return from_page ? from_page->getBCount() : 0; }
  count_t getFromQCount () const { return from_page ? from_page->getQCount() : 0; }

  bool  toDateDirty     () const { return to_page ? to_page->dateDirty() : false; }
  bool  toGradeDirty    () const { return to_page ? to_page->gradeDirty() : false; }
  bool  toBCountDirty   () const { return to_page ? to_page->bCountDirty() : false; }
  bool  toQCountDirty   () const { return to_page ? to_page->qCountDirty() : false; }
  TQString getToFauxAmi  () const { return to_page ? to_page->getFauxAmi() : TQString(""); }

  time_t  getToDate     () const { return to_page ? to_page->getDate() : 0; }
  grade_t getToGrade    () const { return to_page ? to_page->getGrade() : KV_NORM_GRADE; }
  count_t getToBCount   () const { return to_page ? to_page->getBCount() : 0; }
  count_t getToQCount   () const { return to_page ? to_page->getQCount() : 0; }

  bool    lessonDirty  () const { return comm_page->lessonDirty(); }
  bool    usageDirty   () const { return comm_page->usageDirty(); }
  bool    typeDirty    () const { return comm_page->typeDirty  (); }
  bool    activeDirty  () const { return comm_page->activeDirty  (); }

  int     getLesson   ()  const { return comm_page->getLesson(); }
  TQString getType     ()  const { return comm_page->getType(); }
  TQString getExpr     ()  const { return comm_page->getExpr(); }
  TQString getPronunce ()  const { return comm_page->getPronunce(); }
  TQString getUsageLabel() const { return comm_page->getUsageLabel(); }
  bool    getActive()     const { return comm_page->getActive(); }

  TQString getSynonym  () const { return aux_page->getSynonym(); }
  TQString getAntonym  () const { return aux_page->getAntonym(); }
  TQString getRemark   () const { return aux_page->getRemark(); }
  TQString getExample  () const { return aux_page->getExample(); }
  TQString getParaphrase () const { return aux_page->getParaphrase(); }

  Conjugation getConjugation() const { return tense_page->getConjugation(); }

  Comparison getComparison() const { return adj_page->getComparison(); }

  MultipleChoice getMultipleChoice() const { return mc_page->getMultipleChoice(); }

  bool isModified();
  void setModified(bool mod);
  void setEnabled(int);

  void setCell(int row, int col, const vector<TQTableSelection>& sel);
  void getCell(int &row, int &col, vector<TQTableSelection>& sel) const;

signals:
  void sigEditChoice(int);

public slots:
  void slotDisplayModified();
  void slotApply();
  void slotUndo();
  void slotDockHorizontal();
  void slotDockVertical();

protected slots:
  void updatePages(const TQString &type);
  virtual void reject ();

protected:
  virtual void closeEvent (TQCloseEvent*e);

  FromToEntryPage  *from_page,
                    *to_page;
  CommonEntryPage  *comm_page;
  AuxInfoEntryPage *aux_page;
  TenseEntryPage   *tense_page;
  AdjEntryPage     *adj_page;
  MCEntryPage      *mc_page;
  int               edit_row, edit_col;
  TQTabWidget       *tabber;

  vector<TQTableSelection> selections;
  KMainWindow     *mainwin;
  TQSize            oldMainSize;
  TQPoint           oldMainPos;
  bool             docked;
};

#endif // EntryDlg_included
