/***************************************************************************

                      language options for kvoctrain

    -----------------------------------------------------------------------

    begin                : Tue Apr 5 2005

    copyright            :(C) 2005 Peter Hedlund

    email                : peter.hedlund@kdemail.net

    -----------------------------------------------------------------------

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LANGUAGEOPTIONS_H
#define LANGUAGEOPTIONS_H

#include <tqpopupmenu.h>

#include "languageoptionsbase.h"
#include "langset.h"

class LanguageOptions : public LanguageOptionsBase
{
  Q_OBJECT

public:
  LanguageOptions(LangSet & langset, TQWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
  virtual ~LanguageOptions ();

  LangSet getLangSet () const;

  struct Country
  {
    Country(const TQString& c, const TQValueList<int> l, const TQString& p, int i)
      : country(c), langs(l), pixmap(p), id(i) { }
    Country() { }
    TQString country;
    TQValueList<int> langs;
    TQString pixmap;
    int id;
  };

  struct Region
  {
    Region (const TQString& reg)
      : region(reg) {}
    Region() {}
    TQString region;
    TQValueList<Country> countries;
  };

  void updateWidgets();
  bool hasChanged();
  bool isDefault();
  void updateSettings();

signals:
  void widgetModified();

protected slots:
  void slotDeleteClicked();
  void slotNewClicked();
  void slotPixmapClicked();
  void slotLangChanged(const TQString&);
  void slotShort2Changed(const TQString&);
  void slotShortActivated(const TQString&);
  void slotNewNameChanged(const TQString&);
  void slotLangFromGlobalActivated(int);
  void slotLangFromISO6391Activated(int);
  void slotKeyboardLayoutChanged(const TQString&);

private:
  bool setPixmap(TQString pm);
  void enableLangWidgets();
  void loadCountryData();
  void loadISO6391Data();
  void createISO6391Menus();

  LangSet global_langset;
  TQMap<int, Country> countryIdMap;
  TQPopupMenu * langset_popup;
  TQPopupMenu * iso6391_popup;
  LangSet m_langSet;
  TQString m_lastPix;
  bool m_hasChanged;
};

#endif

