/***************************************************************************
                         kpercentmain.h  -  description
                            -------------------
   begin                : Fri Nov 16 2001
   copyright            : (C) 2001 by Matthias Messmer &
                                      Carsten Niehaus &
                                      Robert Gogolok
   email                : bmlmessmer@web.de &
                          cniehaus@gmx.de &
                          mail@robert-gogolok.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPERCENTMAIN_H
#define KPERCENTMAIN_H

// Qt includes

// KDE includes

// local includes
#include "kanswer.h"

class TQGridLayout;
class TQHBoxLayout;
class TQLabel;
class TQLineEdit;
class TQProgressBar;
class TQPushButton;
class TQVBoxLayout;

/**
 * Dialog for the exercises
 * @author Matthias Messmer & Rober Gogolok & Carsten Niehaus
 */
class KPercentMain : public KDialog
{
    Q_OBJECT
    public:
        KPercentMain( TQWidget *parent, const char *name = 0 );
        /** checks, if the task is solved right */
        bool validateTask();
        /** prepares the dialog for a new task */
        void newTask();
        /** gets the numbers from the editlines */
        int getPercentvalue();
        int getBasevalue();
        int getPercentage();
        /** inserts the numbers of a new task in the editlines */
        void showNumbers();
        /** called, if number tasks are managed */
        void finished();
        /** shows the kanswer dialog modal with an proper answer about the success. */
        void showAnswer( int modus );
        /** sets the total amount of tasks selekted in opening screen */
        void setNumber( int anumber );
        /** Prepares the exercise for number tasks
        * espacially fills the arrays with proper numbers */
        void initExercise();

        // Public attributes
        /** total number of exercises */
        int number;
        /** actual number of managed exercises */
        int count;

        /** actual amount of given answers */
        int total_answers;
        /** actual count of right answers */
        int right_answers;
        /** actual count of wrong answers */
        int wrong_answers;

        /** in KPercentage selected type of task */
        int selected_type;
        /** percentages to be calculated with */
        int percentage[ 10 ];
        /** basevalues to be calculated with */
        int basevalue[ 10 ];
        /** percentvalues to be calculated with */
        int percentvalue[ 10 ];

        TQLabel *label_1;
        TQLabel *label_2;
        TQLabel *label_number;
        TQLabel *label_count;

        /** editline for the actual task */
        TQLineEdit *line_edit_input;
        /** editline for the percentage */
        TQLineEdit *line_edit_percentage;
        /** editline for the basevalue */
        TQLineEdit *line_edit_basevalue;
        /** editline for the percentvalue */
        TQLineEdit *line_edit_percentvalue;

        /** showing the effort of the user */
        TQProgressBar *progress_bar_count;
        /** button to apply the current input */
        TQPushButton *push_button_apply;
        /** button to cancel the exercise series */
        TQPushButton *push_button_cancel;
        
        TQProgressBar *progress_bar_right_wrong;
        TQLabel *label_right;
        TQLabel *label_wrong;

        /** the answer window */
        KAnswer *answer;
        /** stores the level selected in KPercentage's combo_box_level */
        int selected_level;

	private:
		void keyPressEvent( TQKeyEvent * e );


    public slots:  // Public slots
        /**
         * checks, if the input is a val. number
         * calls validateTask then and if succeeds causes a newTask
         *
         * @see kpercentmain#validateTask kpercetmain#newTask
         */
        void slotApplyInput();
        /** reimplemented: growing the progressbar step by step */
        void timerEvent( TQTimerEvent * );
};

#endif
