/*
    This file is part of the KDE Password Server

    Copyright (C) 2002 Waldo Bastian (bastian@kde.org)

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    This software is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this library; see the file COPYING. If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/
//----------------------------------------------------------------------------
//
// KDE Password Server
// $Id: kpasswdserver.h 1157647 2010-07-31 19:46:43Z tpearson $

#ifndef KPASSWDSERVER_H
#define KPASSWDSERVER_H

#include <tqdict.h>
#include <tqintdict.h>

#include <dcopclient.h>
#include <kio/authinfo.h>
#include <kded/kdedmodule.h>

namespace KWallet {
    class Wallet;
}

class KPasswdServer : public KDEDModule
{
  Q_OBJECT
  K_DCOP
public:
  KPasswdServer(const TQCString &);
  ~KPasswdServer();

k_dcop:
  // KDE4 merge
  KIO::AuthInfo checkAuthInfo(KIO::AuthInfo, long, unsigned long);
  KIO::AuthInfo checkAuthInfo(KIO::AuthInfo, long);
  KIO::AuthInfo queryAuthInfo(KIO::AuthInfo, TQString, long, long, unsigned long);
  KIO::AuthInfo queryAuthInfo(KIO::AuthInfo, TQString, long, long);
  void addAuthInfo(KIO::AuthInfo, long);

public slots:
  void processRequest();
  // Remove all authentication info associated with windowId
  void removeAuthForWindowId(long windowId);

protected:
  struct AuthInfo;

  TQString createCacheKey( const KIO::AuthInfo &info );
  const AuthInfo *findAuthInfoItem(const TQString &key, const KIO::AuthInfo &info);
  void removeAuthInfoItem(const TQString &key, const KIO::AuthInfo &info);
  void addAuthInfoItem(const TQString &key, const KIO::AuthInfo &info, long windowId, long seqNr, bool canceled);
  KIO::AuthInfo copyAuthInfo(const AuthInfo *);
  void updateAuthExpire(const TQString &key, const AuthInfo *, long windowId, bool keep);
  int findWalletEntry( const TQMap<TQString,TQString>& map, const TQString& username );
  bool openWallet( WId windowId );

  struct AuthInfo {
    AuthInfo() { expire = expNever; isCanceled = false; seqNr = 0; }

    KURL url;
    TQString directory;
    TQString username;
    TQString password;
    TQString realmValue;
    TQString digestInfo;

    enum { expNever, expWindowClose, expTime } expire;
    TQValueList<long> windowList;
    unsigned long expireTime;
    long seqNr;

    bool isCanceled;
  };

  class AuthInfoList : public TQPtrList<AuthInfo>
  {
    public:
      AuthInfoList() { setAutoDelete(true); }
      int compareItems(TQPtrCollection::Item n1, TQPtrCollection::Item n2);
  };

  TQDict< AuthInfoList > m_authDict;

  struct Request {
     DCOPClient *client;
     DCOPClientTransaction *transaction;
     TQString key;
     KIO::AuthInfo info;
     TQString errorMsg;
     long windowId;
     long seqNr;
     bool prompt;
  };

  TQPtrList< Request > m_authPending;
  TQPtrList< Request > m_authWait;
  TQIntDict<TQStringList> mWindowIdList;
  DCOPClient *m_dcopClient;
  KWallet::Wallet* m_wallet;
  long m_seqNr;
};

#endif
