/*
    This file is part of libkabc.
    Copyright (c) 2001 Cornelius Schumacher <schumacher@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef KABC_VCARDFORMATIMPL_H
#define KABC_VCARDFORMATIMPL_H

#include <tqstring.h>
#include <tqfile.h>

#include "address.h"
#include "addressee.h"

#ifdef __CYGWIN__ 
#include <vcard/include/VCard.h>
#else
#include <VCard.h>
#endif 

namespace KABC {

class AddressBook;

/**
  @deprecated use VCardFormatPlugin instead.
 */
class KABC_EXPORT_DEPRECATED VCardFormatImpl
{
  public:
    bool load( Addressee &, TQFile *file );
    bool loadAll( AddressBook *, Resource *, TQFile *file );
    void save( const Addressee &, TQFile *file );
    void saveAll( AddressBook *, Resource *, TQFile *file );

    bool readFromString( const TQString &vcard, Addressee &addr );
    bool writeToString( const Addressee &addressee, TQString &vcard );

  protected:
    bool loadAddressee( Addressee &, VCARD::VCard & );
    void saveAddressee( const Addressee &, VCARD::VCard *, bool intern );

    void addTextValue (VCARD::VCard *, VCARD::EntityType, const TQString & );
    TQString readTextValue( VCARD::ContentLine * );

    void addDateValue( VCARD::VCard *, VCARD::EntityType, const TQDate & );
    TQDate readDateValue( VCARD::ContentLine * );

    void addDateTimeValue( VCARD::VCard *, VCARD::EntityType, const TQDateTime & );
    TQDateTime readDateTimeValue( VCARD::ContentLine * );

    void addAddressValue( VCARD::VCard *, const Address & );
    Address readAddressValue( VCARD::ContentLine * );

    void addLabelValue( VCARD::VCard *, const Address & );

    void addTelephoneValue( VCARD::VCard *, const PhoneNumber & );
    PhoneNumber readTelephoneValue( VCARD::ContentLine * );

    void addNValue( VCARD::VCard *, const Addressee & );
    void readNValue( VCARD::ContentLine *, Addressee & );

    void addCustomValue( VCARD::VCard *, const TQString & );

    void addAddressParam( VCARD::ContentLine *, int );
    int readAddressParam( VCARD::ContentLine * );

    void addGeoValue( VCARD::VCard *, const Geo & );
    Geo readGeoValue( VCARD::ContentLine * );

    void addUTCValue( VCARD::VCard *, const TimeZone & );
    TimeZone readUTCValue( VCARD::ContentLine * );

    void addClassValue( VCARD::VCard *, const Secrecy & );
    Secrecy readClassValue( VCARD::ContentLine * );

    void addKeyValue( VCARD::VCard *, const Key & );
    Key readKeyValue( VCARD::ContentLine * );

    void addPictureValue( VCARD::VCard *, VCARD::EntityType, const Picture &, const Addressee &, bool );
    Picture readPictureValue( VCARD::ContentLine *, VCARD::EntityType, const Addressee &addr );

    void addSoundValue( VCARD::VCard *, const Sound &, const Addressee &, bool );
    Sound readSoundValue( VCARD::ContentLine *, const Addressee &addr );

    void addAgentValue( VCARD::VCard *, const Agent & );
    Agent readAgentValue( VCARD::ContentLine * );
};

}
#endif
