#ifndef MISCUI_H
#define MISCUI_H

#include <tqcombobox.h>
#include <tqcheckbox.h>


//-----------------------------------------------------------------------------
class MeetingCheckBox : public QWidget
{
 Q_OBJECT
 public:
	enum Type { Ready, NotReady, Excluded };
	MeetingCheckBox(Type, bool owner, bool server, TQWidget *parent);

    void setType(Type);
	Type type() const;

 signals:
    void changed(int);

 private slots:
    void changedSlot();

 private:
    TQCheckBox *_ready, *_excluded;
};

//-----------------------------------------------------------------------------
class PlayerComboBox : public QComboBox
{
 Q_OBJECT
 public:
	enum Type { Human = 0, AI, None };
	PlayerComboBox(Type, bool canBeNone, bool acceptAI, TQWidget *parent);

	Type type() const { return (Type)currentItem(); }

 signals:
    void changed(int);
};

#endif // MISCUI_H
