#include "miscui.h"
#include "miscui.moc"

#include <tqlayout.h>

#include <klocale.h>


//-----------------------------------------------------------------------------
MeetingCheckBox::MeetingCheckBox(Type type, bool owner, bool server,
                                 TQWidget *parent)
    : TQWidget(parent, "meeting_check_box")
{
    TQVBoxLayout *vbox = new TQVBoxLayout(this);

    _ready = new TQCheckBox(i18n("Ready"), this);
    vbox->addWidget(_ready);
    _ready->setEnabled(owner);
    connect(_ready, TQT_SIGNAL(clicked()), TQT_SLOT(changedSlot()));

    _excluded = new TQCheckBox(i18n("Excluded"), this);
    vbox->addWidget(_excluded);
    _excluded->setEnabled(server);
    connect(_excluded, TQT_SIGNAL(clicked()), TQT_SLOT(changedSlot()));

    setType(type);
}

void MeetingCheckBox::setType(Type type)
{
    _ready->setChecked( type==Ready );
    _excluded->setChecked( type==Excluded );
}

MeetingCheckBox::Type MeetingCheckBox::type() const
{
    if ( _excluded->isChecked() ) return Excluded;
    if ( _ready->isChecked() ) return Ready;
    return NotReady;
}

void MeetingCheckBox::changedSlot()
{
    emit changed(type());
}

//-----------------------------------------------------------------------------
PlayerComboBox::PlayerComboBox(Type type, bool canBeEmpty, bool acceptAI,
                               TQWidget *parent)
    : TQComboBox(parent, "player_combo_box")
{
    insertItem(i18n("Human"));
    if (acceptAI) insertItem(i18n("AI"));
    if (canBeEmpty) insertItem(i18n("None"));
    setCurrentItem(type);

    connect(this, TQT_SIGNAL(activated(int)), TQT_SIGNAL(changed(int)));
}
