#ifndef COMMON_TYPES_H
#define COMMON_TYPES_H

#include <tqdatastream.h>

#include "lib/libksirtet_export.h"


struct ClientPlayData { Q_UINT8 height, gift, end; };
LIBKSIRTET_EXPORT TQDataStream &operator <<(TQDataStream &s, const ClientPlayData &d);
LIBKSIRTET_EXPORT TQDataStream &operator >>(TQDataStream &s, ClientPlayData &d);

struct ServerPlayData { Q_UINT8 prevHeight, nextHeight, gift; };
LIBKSIRTET_EXPORT TQDataStream &operator <<(TQDataStream &s, const ServerPlayData &d);
LIBKSIRTET_EXPORT TQDataStream &operator >>(TQDataStream &s, ServerPlayData &d);

class ServerInitData
{
 public:
	TQString  prevName, nextName, name;
	Q_UINT32 initLevel, seed;
};
LIBKSIRTET_EXPORT TQDataStream &operator <<(TQDataStream &s, const ServerInitData &d);
LIBKSIRTET_EXPORT TQDataStream &operator >>(TQDataStream &s, ServerInitData &d);

#endif
