#include "main.h"
#include "main.moc"

#include <kaction.h>
#include <kstdaction.h>
#include <kmenubar.h>
#include <kstdgameaction.h>
#include <kcmenumngr.h>
#include <kkeydialog.h>
#include <klocale.h>
#include <knotifyclient.h>
#include <knotifydialog.h>
#include <kexthighscore.h>
#include <kconfigdialog.h>

#include "inter.h"
#include "factory.h"
#include "settings.h"
#include "baseprefs.h"

BaseMainWindow::BaseMainWindow()
  : KZoomMainWindow(4, 100, 1, "main_window")
{
    KNotifyClient::startDaemon();

    // File & Popup
    KStdGameAction::gameNew(this, TQT_SLOT(start()), actionCollection());
    _pause = KStdGameAction::pause(this, TQT_SLOT(pause()), actionCollection());
    _pause->setEnabled(false);
    KStdGameAction::highscores(this, TQT_SLOT(showHighscores()),
                               actionCollection());
    KStdGameAction::quit(qApp, TQT_SLOT(quit()), actionCollection());

    // Settings
    KStdAction::preferences(this, TQT_SLOT(configureSettings()),
                            actionCollection());
    KStdAction::keyBindings(this, TQT_SLOT(configureKeys()), actionCollection());
    KStdAction::configureNotifications(this, TQT_SLOT(configureNotifications()),
                                       actionCollection());
    KStdGameAction::configureHighscores(this, TQT_SLOT(configureHighscores()),
                                        actionCollection());

    _inter = bfactory->createInterface(this);
}

void BaseMainWindow::buildGUI(TQWidget *widget)
{
    createGUI();
    setCentralWidget(widget);
    init("popup");
}

BaseMainWindow::~BaseMainWindow()
{
    delete _inter;
}

void BaseMainWindow::showHighscores()
{
    _inter->showHighscores(this);
}

void BaseMainWindow::start()
{
    _inter->_start();
}

void BaseMainWindow::pause()
{
    _inter->_pause();
}

void BaseMainWindow::configureHighscores()
{
    KExtHighscore::configure(this);
}

void BaseMainWindow::configureSettings()
{
    if ( !_inter->_isPaused() ) _inter->_pause();
    if ( KConfigDialog::showDialog("settings") ) return;

    KConfigDialog *dialog = new KConfigDialog(this, "settings", BasePrefs::self() );
    TQWidget *w = bfactory->createGameConfig();
    if (w) dialog->addPage(w, i18n("Game"), "package_system");
    w = bfactory->createAppearanceConfig();
    if (w) dialog->addPage(w, i18n("Appearance"), "style");
    w = bfactory->createColorConfig();
    if (w) dialog->addPage(w, i18n("Colors"), "colorize");
//    dialog->addPage(new BackgroundConfigWidget, i18n("Background"), "background");
    addConfig(dialog);
    connect(dialog, TQT_SIGNAL(settingsChanged()), TQT_SIGNAL(settingsChanged()));
    dialog->show();
}

void BaseMainWindow::configureKeys()
{
    KKeyDialog d(true, this);
    addKeys(d);
    d.insert(actionCollection());
    d.configure(false);
    actionCollection()->writeShortcutSettings();
    saveKeys();
}

void BaseMainWindow::configureNotifications()
{
    KNotifyDialog::configure(this);
}

void BaseMainWindow::writeZoomSetting(uint zoom)
{
  BasePrefs::setBlockSize(zoom);
  BasePrefs::writeConfig();
}

uint BaseMainWindow::readZoomSetting() const
{
  return BasePrefs::blockSize();
}

void BaseMainWindow::writeMenubarVisibleSetting(bool visible)
{
  BasePrefs::setMenubarVisible(visible);
  BasePrefs::writeConfig();
}

bool BaseMainWindow::menubarVisibleSetting() const
{
  return BasePrefs::menubarVisible();
}
