/* -------------------------------------------------------------
   KDE Tuberling
   Sound factory
   mailto:e.bischoff@noos.fr
 ------------------------------------------------------------- */


#ifndef _SOUNDFACTORY_H_
#define _SOUNDFACTORY_H_

#include "tqobject.h"

class TQDomDocument;
class TopLevel;

class SoundFactory : public QObject
{
  Q_OBJECT

public:

  SoundFactory(TopLevel *parent, const char *name, uint selectedLanguage);
  ~SoundFactory();

  void change(uint selectedLanguage);
  void playSound(const TQString &soundRef) const;

protected:

  bool registerLanguages(TQDomDocument &layoutDocument);
  bool loadLanguage(TQDomDocument &layoutDocument, uint toLoad);

private:

  void loadFailure();

private:

  int sounds;			// Number of sounds
  TQString *namesList,		// List of sound names
  	  *filesList;           // List of sound files associated with each sound name

  TopLevel *topLevel;		// Top-level window
};

#endif
