/*
 *  ksokoban - a Sokoban game for KDE
 *  Copyright (C) 1998  Anders Widell  <awl@hem.passagen.se>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "ModalLabel.h"

#include <tqlabel.h>
#include <tqfont.h>
#include <kapplication.h>
#include <kglobalsettings.h>
#include <tqwidgetlist.h>
#include <tqstring.h>

#include "ModalLabel.moc"

ModalLabel::ModalLabel(const TQString &text, TQWidget *parent,
		       const char *name, WFlags f)
  : TQLabel(text, parent, name, f) {
  TQFont font(KGlobalSettings::generalFont().family(), 24, TQFont::Bold);
  TQFontMetrics fontMet(font);

  TQString currentLine;
  TQRect bounds;
  int lineLen, width=0, height=0;

  for (int linePos=0; linePos < (int) text.length(); linePos += lineLen+1) {

    lineLen = text.find('\n', linePos);
    if (lineLen < 0) lineLen = text.length() - linePos;
    else lineLen -= linePos;

    currentLine = text.mid(linePos, lineLen);
    bounds = fontMet.boundingRect(currentLine);

    if (bounds.width() > width) width = bounds.width();
    height += bounds.height();
  }

  width += 32;
  height += 32;

  if (width < 300) width = 300;
  if (height < 75) height = 75;

  setAlignment (AlignCenter);
  setFrameStyle (TQFrame::Panel | TQFrame::Raised);
  setLineWidth (4);
  setFont (font);
  move (parent->width ()/2 - width/2, parent->height ()/2 - height/2);
  resize (width, height);
  show ();

  TQWidgetList  *list = TQApplication::allWidgets();
  TQWidgetListIt it( *list );
  while (it.current()) {
    it.current()->installEventFilter (this);
    ++it;
  }
  delete list;

  completed_ = false;
  startTimer (1000);
}

void
ModalLabel::timerEvent (TQTimerEvent *) {
  completed_ = true;
}

bool
ModalLabel::eventFilter (TQObject *, TQEvent *e) {
  switch (e->type()) {
    case TQEvent::MouseButtonPress:
    case TQEvent::MouseButtonRelease:
    case TQEvent::MouseButtonDblClick:
    case TQEvent::MouseMove:
    case TQEvent::KeyPress:
    case TQEvent::KeyRelease:
    case TQEvent::Accel:
      //case TQEvent::DragEnter:
    case TQEvent::DragMove:
    case TQEvent::DragLeave:
    case TQEvent::Drop:
      //case TQEvent::DragResponse:

      //kdDebug << "Ate event" << endl;
    return true;
    break;
  default:
    return false;
  }
}

void
ModalLabel::message (const TQString &text, TQWidget *parent) {
  KApplication *app = KApplication::kApplication ();
  ModalLabel cl (text, parent);

  while (!cl.completed_) app->processOneEvent ();
}
